/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.MemberSubscription;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;

public class GroupSpecImpl
implements GroupSpec {
    private final Map<String, MemberSubscriptionAndAssignmentImpl> members;
    private final SubscriptionType subscriptionType;
    private final Map<Uuid, Map<Integer, String>> invertedMemberAssignment;

    public GroupSpecImpl(Map<String, MemberSubscriptionAndAssignmentImpl> members, SubscriptionType subscriptionType, Map<Uuid, Map<Integer, String>> invertedMemberAssignment) {
        this.members = Objects.requireNonNull(members);
        this.subscriptionType = Objects.requireNonNull(subscriptionType);
        this.invertedMemberAssignment = Objects.requireNonNull(invertedMemberAssignment);
    }

    public Collection<String> memberIds() {
        return this.members.keySet();
    }

    public SubscriptionType subscriptionType() {
        return this.subscriptionType;
    }

    public boolean isPartitionAssigned(Uuid topicId, int partitionId) {
        Map<Integer, String> partitionMap = this.invertedMemberAssignment.get(topicId);
        if (partitionMap == null) {
            return false;
        }
        return partitionMap.containsKey(partitionId);
    }

    public MemberSubscription memberSubscription(String memberId) {
        MemberSubscription memberSubscription = this.members.get(memberId);
        if (memberSubscription == null) {
            throw new IllegalArgumentException("Member Id " + memberId + " not found.");
        }
        return memberSubscription;
    }

    public MemberAssignment memberAssignment(String memberId) {
        MemberSubscriptionAndAssignmentImpl member = this.members.get(memberId);
        if (member == null) {
            return new MemberAssignmentImpl(Collections.emptyMap());
        }
        return member;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupSpecImpl that = (GroupSpecImpl)o;
        return this.subscriptionType == that.subscriptionType && this.members.equals(that.members) && this.invertedMemberAssignment.equals(that.invertedMemberAssignment);
    }

    public int hashCode() {
        int result = this.members.hashCode();
        result = 31 * result + this.subscriptionType.hashCode();
        result = 31 * result + this.invertedMemberAssignment.hashCode();
        return result;
    }

    public String toString() {
        return "GroupSpecImpl(members=" + this.members + ", subscriptionType=" + this.subscriptionType + ", invertedMemberAssignment=" + this.invertedMemberAssignment + ')';
    }
}

