/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.kafka.trogdor.common.JsonUtil;

public final class Kibosh {
    public static final Kibosh INSTANCE = new Kibosh();
    public static final String KIBOSH_CONTROL = "kibosh_control";
    private final TreeMap<String, KiboshProcess> processes = new TreeMap();

    private Kibosh() {
    }

    private synchronized KiboshProcess findProcessObject(String mountPath) {
        String path = Paths.get(mountPath, new String[0]).normalize().toString();
        KiboshProcess process = this.processes.get(path);
        if (process == null) {
            process = new KiboshProcess(mountPath);
            this.processes.put(path, process);
        }
        return process;
    }

    void addFault(String mountPath, KiboshFaultSpec spec) throws IOException {
        KiboshProcess process = this.findProcessObject(mountPath);
        process.addFault(spec);
    }

    void removeFault(String mountPath, KiboshFaultSpec spec) throws IOException {
        KiboshProcess process = this.findProcessObject(mountPath);
        process.removeFault(spec);
    }

    public static class KiboshControlFile {
        private final List<KiboshFaultSpec> faults;
        public static final KiboshControlFile EMPTY = new KiboshControlFile(Collections.emptyList());

        public static KiboshControlFile read(Path controlPath) throws IOException {
            byte[] controlFileBytes = Files.readAllBytes(controlPath);
            return (KiboshControlFile)JsonUtil.JSON_SERDE.readValue(controlFileBytes, KiboshControlFile.class);
        }

        @JsonCreator
        public KiboshControlFile(@JsonProperty(value="faults") List<KiboshFaultSpec> faults) {
            this.faults = faults == null ? new ArrayList() : faults;
        }

        @JsonProperty
        public List<KiboshFaultSpec> faults() {
            return this.faults;
        }

        public void write(Path controlPath) throws IOException {
            Files.write(controlPath, JsonUtil.JSON_SERDE.writeValueAsBytes((Object)this), new OpenOption[0]);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Objects.equals(this.toString(), o.toString());
        }

        public final int hashCode() {
            return this.toString().hashCode();
        }

        public final String toString() {
            return JsonUtil.toJsonString(this);
        }
    }

    private static class KiboshProcess {
        private final Path controlPath;

        KiboshProcess(String mountPath) {
            this.controlPath = Paths.get(mountPath, Kibosh.KIBOSH_CONTROL);
            if (!Files.exists(this.controlPath, new LinkOption[0])) {
                throw new RuntimeException("Can't find file " + this.controlPath);
            }
        }

        synchronized void addFault(KiboshFaultSpec toAdd) throws IOException {
            KiboshControlFile file = KiboshControlFile.read(this.controlPath);
            ArrayList<KiboshFaultSpec> faults = new ArrayList<KiboshFaultSpec>(file.faults());
            faults.add(toAdd);
            new KiboshControlFile(faults).write(this.controlPath);
        }

        synchronized void removeFault(KiboshFaultSpec toRemove) throws IOException {
            KiboshControlFile file = KiboshControlFile.read(this.controlPath);
            ArrayList<KiboshFaultSpec> faults = new ArrayList<KiboshFaultSpec>();
            boolean foundToRemove = false;
            for (KiboshFaultSpec fault : file.faults()) {
                if (fault.equals(toRemove)) {
                    foundToRemove = true;
                    continue;
                }
                faults.add(fault);
            }
            if (!foundToRemove) {
                throw new RuntimeException("Failed to find fault " + toRemove + ". ");
            }
            new KiboshControlFile(faults).write(this.controlPath);
        }
    }

    public static class KiboshFilesUnreadableFaultSpec
    extends KiboshFaultSpec {
        private final String prefix;
        private final int errorCode;

        @JsonCreator
        public KiboshFilesUnreadableFaultSpec(@JsonProperty(value="prefix") String prefix, @JsonProperty(value="errorCode") int errorCode) {
            this.prefix = prefix;
            this.errorCode = errorCode;
        }

        @JsonProperty
        public String prefix() {
            return this.prefix;
        }

        @JsonProperty
        public int errorCode() {
            return this.errorCode;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=KiboshFilesUnreadableFaultSpec.class, name="unreadable")})
    public static abstract class KiboshFaultSpec {
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Objects.equals(this.toString(), o.toString());
        }

        public final int hashCode() {
            return this.toString().hashCode();
        }

        public final String toString() {
            return JsonUtil.toJsonString(this);
        }
    }
}

