/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.consumer.MemberAssignmentImpl;
import org.apache.kafka.server.common.TopicIdPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniformHeterogeneousAssignmentBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(UniformHeterogeneousAssignmentBuilder.class);
    private final GroupSpec groupSpec;
    private final SubscribedTopicDescriber subscribedTopicDescriber;
    private final Set<Uuid> subscribedTopicIds;
    private final Map<Uuid, List<String>> membersPerTopic;
    private final Map<String, MemberAssignment> targetAssignment;
    private final Set<TopicIdPartition> unassignedPartitions;
    private final Set<TopicIdPartition> assignedStickyPartitions;
    private final AssignmentManager assignmentManager;
    private final TreeSet<String> sortedMembersByAssignmentSize;
    private final Map<TopicIdPartition, String> partitionOwnerInTargetAssignment;
    private final PartitionMovements partitionMovements;

    public UniformHeterogeneousAssignmentBuilder(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        this.groupSpec = groupSpec;
        this.subscribedTopicDescriber = subscribedTopicDescriber;
        this.subscribedTopicIds = new HashSet<Uuid>();
        this.membersPerTopic = new HashMap<Uuid, List<String>>();
        this.targetAssignment = new HashMap<String, MemberAssignment>();
        groupSpec.memberIds().forEach(memberId -> {
            groupSpec.memberSubscription(memberId).subscribedTopicIds().forEach(topicId -> {
                int partitionCount = subscribedTopicDescriber.numPartitions(topicId);
                if (partitionCount == -1) {
                    throw new PartitionAssignorException("Members are subscribed to topic " + topicId + " which doesn't exist in the topic metadata.");
                }
                this.subscribedTopicIds.add((Uuid)topicId);
                this.membersPerTopic.computeIfAbsent((Uuid)topicId, k -> new ArrayList()).add(memberId);
            });
            this.targetAssignment.put((String)memberId, new MemberAssignmentImpl(new HashMap<Uuid, Set<Integer>>()));
        });
        this.unassignedPartitions = UniformHeterogeneousAssignmentBuilder.topicIdPartitions(this.subscribedTopicIds, subscribedTopicDescriber);
        this.assignedStickyPartitions = new HashSet<TopicIdPartition>();
        this.assignmentManager = new AssignmentManager(this.subscribedTopicDescriber);
        this.sortedMembersByAssignmentSize = this.assignmentManager.sortMembersByAssignmentSize(groupSpec.memberIds());
        this.partitionOwnerInTargetAssignment = new HashMap<TopicIdPartition, String>();
        this.partitionMovements = new PartitionMovements();
    }

    public GroupAssignment build() {
        if (this.subscribedTopicIds.isEmpty()) {
            LOG.info("The subscription list is empty, returning an empty assignment");
            return new GroupAssignment(Collections.emptyMap());
        }
        this.assignStickyPartitions();
        this.unassignedPartitionsAssignment();
        this.balance();
        return new GroupAssignment(this.targetAssignment);
    }

    private List<TopicIdPartition> sortTopicIdPartitions(Collection<TopicIdPartition> topicIdPartitions) {
        Comparator<TopicIdPartition> comparator = Comparator.comparingDouble(topicIdPartition -> {
            int totalPartitions = this.subscribedTopicDescriber.numPartitions(topicIdPartition.topicId());
            int totalSubscribers = this.membersPerTopic.get(topicIdPartition.topicId()).size();
            return (double)totalPartitions / (double)totalSubscribers;
        }).reversed().thenComparingInt(topicIdPartition -> this.membersPerTopic.get(topicIdPartition.topicId()).size()).thenComparingInt(TopicIdPartition::partitionId);
        return topicIdPartitions.stream().sorted(comparator).collect(Collectors.toList());
    }

    private void assignStickyPartitions() {
        this.groupSpec.memberIds().forEach(memberId -> this.groupSpec.memberAssignment(memberId).partitions().forEach((topicId, currentAssignment) -> {
            if (this.groupSpec.memberSubscription(memberId).subscribedTopicIds().contains(topicId)) {
                currentAssignment.forEach(partition -> {
                    TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, partition.intValue());
                    this.assignmentManager.addPartitionToTargetAssignment(topicIdPartition, memberId);
                    this.assignedStickyPartitions.add(topicIdPartition);
                });
            } else {
                LOG.debug("The topic " + topicId + " is no longer present in the subscribed topics list");
            }
        }));
    }

    private void unassignedPartitionsAssignment() {
        List<TopicIdPartition> sortedPartitions = this.sortTopicIdPartitions(this.unassignedPartitions);
        for (TopicIdPartition partition : sortedPartitions) {
            String member;
            TreeSet sortedMembers = this.assignmentManager.sortMembersByAssignmentSize(this.membersPerTopic.get(partition.topicId()));
            Iterator iterator = sortedMembers.iterator();
            while (iterator.hasNext() && !this.assignmentManager.maybeAssignPartitionToMember(partition, member = (String)iterator.next())) {
            }
        }
    }

    private boolean canTopicParticipateInReassignment(Uuid topicId) {
        return this.membersPerTopic.get(topicId).size() >= 2;
    }

    private boolean canMemberParticipateInReassignment(String memberId) {
        int maxAssignmentSize;
        Set assignedTopicIds = this.targetAssignment.get(memberId).partitions().keySet();
        int currentAssignmentSize = this.assignmentManager.targetAssignmentSize(memberId);
        if (currentAssignmentSize > (maxAssignmentSize = this.assignmentManager.maxAssignmentSize(memberId))) {
            LOG.error("The member {} is assigned more partitions than the maximum possible.", (Object)memberId);
        }
        if (currentAssignmentSize < maxAssignmentSize) {
            return true;
        }
        for (Uuid topicId : assignedTopicIds) {
            if (!this.canTopicParticipateInReassignment(topicId)) continue;
            return true;
        }
        return false;
    }

    private boolean isBalanced() {
        int max;
        int min = this.assignmentManager.targetAssignmentSize(this.sortedMembersByAssignmentSize.first());
        if (min >= (max = this.assignmentManager.targetAssignmentSize(this.sortedMembersByAssignmentSize.last())) - 1) {
            return true;
        }
        for (String member : this.sortedMembersByAssignmentSize) {
            int maxAssignmentSize;
            int memberPartitionCount = this.assignmentManager.targetAssignmentSize(member);
            if (memberPartitionCount == (maxAssignmentSize = this.assignmentManager.maxAssignmentSize(member))) continue;
            for (Uuid topicId : this.groupSpec.memberSubscription(member).subscribedTopicIds()) {
                Set assignedPartitions = (Set)this.targetAssignment.get(member).partitions().get(topicId);
                for (int i = 0; i < this.subscribedTopicDescriber.numPartitions(topicId); ++i) {
                    String otherMember;
                    int otherMemberPartitionCount;
                    TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, i);
                    if (assignedPartitions != null && assignedPartitions.contains(i) || memberPartitionCount + 1 >= (otherMemberPartitionCount = this.assignmentManager.targetAssignmentSize(otherMember = this.partitionOwnerInTargetAssignment.get(topicIdPartition)))) continue;
                    LOG.debug("{} can be moved from member {} to member {} for a more balanced assignment.", new Object[]{topicIdPartition, otherMember, member});
                    return false;
                }
            }
        }
        return true;
    }

    private void balance() {
        if (!this.unassignedPartitions.isEmpty()) {
            throw new PartitionAssignorException("Some partitions were left unassigned");
        }
        this.unassignedPartitions.addAll(UniformHeterogeneousAssignmentBuilder.topicIdPartitions(this.subscribedTopicIds, this.subscribedTopicDescriber));
        HashSet<TopicIdPartition> fixedPartitions = new HashSet<TopicIdPartition>();
        for (Uuid topicId : this.subscribedTopicIds) {
            if (this.canTopicParticipateInReassignment(topicId)) continue;
            for (int i = 0; i < this.subscribedTopicDescriber.numPartitions(topicId); ++i) {
                fixedPartitions.add(new TopicIdPartition(topicId, i));
            }
        }
        this.unassignedPartitions.removeAll(fixedPartitions);
        for (String member : this.groupSpec.memberIds()) {
            if (this.canMemberParticipateInReassignment(member)) continue;
            this.sortedMembersByAssignmentSize.remove(member);
        }
        if (!this.unassignedPartitions.isEmpty()) {
            this.performReassignments();
        }
    }

    private void performReassignments() {
        boolean modified;
        do {
            modified = false;
            boolean reassignmentOccurred = false;
            List<TopicIdPartition> reassignablePartitions = this.sortTopicIdPartitions(this.unassignedPartitions);
            block1: for (TopicIdPartition reassignablePartition : reassignablePartitions) {
                if (reassignmentOccurred && this.isBalanced()) {
                    return;
                }
                reassignmentOccurred = false;
                if (this.membersPerTopic.get(reassignablePartition.topicId()).size() <= 1) {
                    throw new PartitionAssignorException(String.format("Expected more than one potential member for topicIdPartition '%s'", reassignablePartition));
                }
                String currentTargetOwner = this.partitionOwnerInTargetAssignment.get(reassignablePartition);
                if (currentTargetOwner == null) {
                    throw new PartitionAssignorException(String.format("Expected topicIdPartition '%s' to be assigned to a member", reassignablePartition));
                }
                for (String otherMember : this.membersPerTopic.get(reassignablePartition.topicId())) {
                    if (this.assignmentManager.targetAssignmentSize(currentTargetOwner) <= this.assignmentManager.targetAssignmentSize(otherMember) + 1) continue;
                    this.reassignPartition(reassignablePartition);
                    modified = true;
                    reassignmentOccurred = true;
                    continue block1;
                }
            }
        } while (modified);
    }

    private void reassignPartition(TopicIdPartition partition) {
        String newOwner = null;
        for (String anotherMember : this.sortedMembersByAssignmentSize) {
            if (!this.groupSpec.memberSubscription(anotherMember).subscribedTopicIds().contains(partition.topicId())) continue;
            newOwner = anotherMember;
            break;
        }
        if (newOwner == null) {
            throw new PartitionAssignorException("No suitable new owner was found for the partition" + partition);
        }
        this.reassignPartition(partition, newOwner);
    }

    private void reassignPartition(TopicIdPartition partition, String newMember) {
        String member = this.partitionOwnerInTargetAssignment.get(partition);
        TopicIdPartition partitionToBeMoved = this.partitionMovements.computeActualPartitionToBeMoved(partition, member, newMember);
        this.processPartitionMovement(partitionToBeMoved, newMember);
    }

    private void processPartitionMovement(TopicIdPartition topicIdPartition, String newMember) {
        String oldMember = this.partitionOwnerInTargetAssignment.get(topicIdPartition);
        this.partitionMovements.movePartition(topicIdPartition, oldMember, newMember);
        this.assignmentManager.removePartitionFromTargetAssignment(topicIdPartition, oldMember);
        this.assignmentManager.addPartitionToTargetAssignment(topicIdPartition, newMember);
    }

    private static void addPartitionToAssignment(Map<String, MemberAssignment> memberAssignments, String memberId, Uuid topicId, int partition) {
        memberAssignments.get(memberId).partitions().computeIfAbsent(topicId, __ -> new HashSet()).add(partition);
    }

    private static Set<TopicIdPartition> topicIdPartitions(Collection<Uuid> topicIds, SubscribedTopicDescriber subscribedTopicDescriber) {
        HashSet<TopicIdPartition> topicIdPartitions = new HashSet<TopicIdPartition>();
        for (Uuid topicId : topicIds) {
            int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
            for (int partitionId = 0; partitionId < numPartitions; ++partitionId) {
                topicIdPartitions.add(new TopicIdPartition(topicId, partitionId));
            }
        }
        return topicIdPartitions;
    }

    private class AssignmentManager {
        private final Map<String, MemberAssignmentData> membersWithAssignmentSizes = new HashMap<String, MemberAssignmentData>();

        public AssignmentManager(SubscribedTopicDescriber subscribedTopicDescriber) {
            UniformHeterogeneousAssignmentBuilder.this.groupSpec.memberIds().forEach(memberId -> {
                int maxSize = UniformHeterogeneousAssignmentBuilder.this.groupSpec.memberSubscription(memberId).subscribedTopicIds().stream().mapToInt(arg_0 -> ((SubscribedTopicDescriber)subscribedTopicDescriber).numPartitions(arg_0)).sum();
                MemberAssignmentData memberAssignmentData = this.membersWithAssignmentSizes.computeIfAbsent((String)memberId, x$0 -> new MemberAssignmentData((String)x$0));
                memberAssignmentData.maxAssignmentSize = maxSize;
                memberAssignmentData.currentAssignmentSize = 0;
            });
        }

        private int targetAssignmentSize(String memberId) {
            MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
            if (memberData == null) {
                LOG.warn("Member Id {} not found", (Object)memberId);
                return 0;
            }
            return memberData.currentAssignmentSize;
        }

        private int maxAssignmentSize(String memberId) {
            MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
            if (memberData == null) {
                LOG.warn("Member Id {} not found", (Object)memberId);
                return 0;
            }
            return memberData.maxAssignmentSize;
        }

        private boolean isMemberAtMaxCapacity(String memberId) {
            return this.targetAssignmentSize(memberId) >= this.maxAssignmentSize(memberId);
        }

        private void incrementTargetAssignmentSize(String memberId) {
            MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
            if (memberData == null) {
                LOG.warn("Member Id {} not found", (Object)memberId);
                return;
            }
            ++memberData.currentAssignmentSize;
        }

        private void decrementTargetAssignmentSize(String memberId) {
            MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
            if (memberData == null) {
                LOG.warn("Member Id {} not found", (Object)memberId);
                return;
            }
            if (memberData.currentAssignmentSize > 0) {
                --memberData.currentAssignmentSize;
            }
        }

        private boolean maybeAssignPartitionToMember(TopicIdPartition topicIdPartition, String memberId) {
            if (!UniformHeterogeneousAssignmentBuilder.this.groupSpec.memberSubscription(memberId).subscribedTopicIds().contains(topicIdPartition.topicId())) {
                return false;
            }
            if (this.isMemberAtMaxCapacity(memberId)) {
                return false;
            }
            this.addPartitionToTargetAssignment(topicIdPartition, memberId);
            return true;
        }

        private void addPartitionToTargetAssignment(TopicIdPartition topicIdPartition, String memberId) {
            UniformHeterogeneousAssignmentBuilder.addPartitionToAssignment(UniformHeterogeneousAssignmentBuilder.this.targetAssignment, memberId, topicIdPartition.topicId(), topicIdPartition.partitionId());
            UniformHeterogeneousAssignmentBuilder.this.partitionOwnerInTargetAssignment.put(topicIdPartition, memberId);
            UniformHeterogeneousAssignmentBuilder.this.sortedMembersByAssignmentSize.remove(memberId);
            UniformHeterogeneousAssignmentBuilder.this.assignmentManager.incrementTargetAssignmentSize(memberId);
            if (!this.isMemberAtMaxCapacity(memberId)) {
                UniformHeterogeneousAssignmentBuilder.this.sortedMembersByAssignmentSize.add(memberId);
            }
            UniformHeterogeneousAssignmentBuilder.this.unassignedPartitions.remove(topicIdPartition);
        }

        private void removePartitionFromTargetAssignment(TopicIdPartition topicIdPartition, String memberId) {
            Map targetPartitionsMap = ((MemberAssignment)UniformHeterogeneousAssignmentBuilder.this.targetAssignment.get(memberId)).partitions();
            Set partitionsSet = (Set)targetPartitionsMap.get(topicIdPartition.topicId());
            if (partitionsSet != null) {
                partitionsSet.remove(topicIdPartition.partitionId());
                if (partitionsSet.isEmpty()) {
                    targetPartitionsMap.remove(topicIdPartition.topicId());
                }
            }
            UniformHeterogeneousAssignmentBuilder.this.partitionOwnerInTargetAssignment.remove(topicIdPartition, memberId);
            UniformHeterogeneousAssignmentBuilder.this.sortedMembersByAssignmentSize.remove(memberId);
            UniformHeterogeneousAssignmentBuilder.this.assignmentManager.decrementTargetAssignmentSize(memberId);
            if (!this.isMemberAtMaxCapacity(memberId)) {
                UniformHeterogeneousAssignmentBuilder.this.sortedMembersByAssignmentSize.add(memberId);
            }
        }

        private TreeSet<String> sortMembersByAssignmentSize(Collection<String> memberIds) {
            Comparator<String> comparator = Comparator.comparingInt(memberId -> this.membersWithAssignmentSizes.get((Object)memberId).currentAssignmentSize).thenComparing(memberId -> memberId);
            return memberIds.stream().filter(memberId -> {
                MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
                return memberData.currentAssignmentSize < memberData.maxAssignmentSize;
            }).collect(Collectors.toCollection(() -> new TreeSet(comparator)));
        }

        private class MemberAssignmentData {
            final String memberId;
            int currentAssignmentSize = 0;
            int maxAssignmentSize;

            MemberAssignmentData(String memberId) {
                this.memberId = memberId;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MemberAssignmentData that = (MemberAssignmentData)o;
                return this.memberId.equals(that.memberId);
            }

            public int hashCode() {
                return Objects.hash(this.memberId);
            }

            public String toString() {
                return "MemberAssignmentData(memberId='" + this.memberId + '\'' + ", currentAssignmentSize=" + this.currentAssignmentSize + ", maxAssignmentSize=" + this.maxAssignmentSize + ')';
            }
        }
    }

    private static class PartitionMovements {
        private final Map<Uuid, Map<MemberPair, Set<TopicIdPartition>>> partitionMovementsByTopic = new HashMap<Uuid, Map<MemberPair, Set<TopicIdPartition>>>();
        private final Map<TopicIdPartition, MemberPair> partitionMovementsByPartition = new HashMap<TopicIdPartition, MemberPair>();

        private PartitionMovements() {
        }

        private MemberPair removeMovementRecordOfPartition(TopicIdPartition partition) {
            MemberPair pair = this.partitionMovementsByPartition.remove(partition);
            Uuid topic = partition.topicId();
            Map<MemberPair, Set<TopicIdPartition>> partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic);
            partitionMovementsForThisTopic.get(pair).remove(partition);
            if (partitionMovementsForThisTopic.get(pair).isEmpty()) {
                partitionMovementsForThisTopic.remove(pair);
            }
            if (this.partitionMovementsByTopic.get(topic).isEmpty()) {
                this.partitionMovementsByTopic.remove(topic);
            }
            return pair;
        }

        private void addPartitionMovementRecord(TopicIdPartition partition, MemberPair pair) {
            Map<MemberPair, Set<TopicIdPartition>> partitionMovementsForThisTopic;
            this.partitionMovementsByPartition.put(partition, pair);
            Uuid topic = partition.topicId();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                this.partitionMovementsByTopic.put(topic, new HashMap());
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(pair)) {
                partitionMovementsForThisTopic.put(pair, new HashSet());
            }
            partitionMovementsForThisTopic.get(pair).add(partition);
        }

        private void movePartition(TopicIdPartition partition, String oldOwner, String newOwner) {
            MemberPair pair = new MemberPair(oldOwner, newOwner);
            if (this.partitionMovementsByPartition.containsKey(partition)) {
                MemberPair existingPair = this.removeMovementRecordOfPartition(partition);
                if (existingPair.dstMemberId.equals(oldOwner)) {
                    throw new PartitionAssignorException("Mismatch in partition movement record with respect to partition ownership during a rebalance");
                }
                if (!existingPair.srcMemberId.equals(newOwner)) {
                    this.addPartitionMovementRecord(partition, new MemberPair(existingPair.srcMemberId, newOwner));
                }
            } else {
                this.addPartitionMovementRecord(partition, pair);
            }
        }

        private TopicIdPartition computeActualPartitionToBeMoved(TopicIdPartition partition, String oldOwner, String newOwner) {
            MemberPair reversePair;
            Map<MemberPair, Set<TopicIdPartition>> partitionMovementsForThisTopic;
            Uuid topic = partition.topicId();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                return partition;
            }
            if (this.partitionMovementsByPartition.containsKey(partition)) {
                String expectedOldOwner = this.partitionMovementsByPartition.get(partition).dstMemberId;
                if (!oldOwner.equals(expectedOldOwner)) {
                    throw new PartitionAssignorException("Old owner does not match expected value for partition: " + partition);
                }
                oldOwner = this.partitionMovementsByPartition.get(partition).srcMemberId;
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(reversePair = new MemberPair(newOwner, oldOwner))) {
                return partition;
            }
            return partitionMovementsForThisTopic.get(reversePair).iterator().next();
        }
    }

    private static class MemberPair {
        private final String srcMemberId;
        private final String dstMemberId;

        MemberPair(String srcMemberId, String dstMemberId) {
            this.srcMemberId = srcMemberId;
            this.dstMemberId = dstMemberId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.srcMemberId == null ? 0 : this.srcMemberId.hashCode());
            result = 31 * result + (this.dstMemberId == null ? 0 : this.dstMemberId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            MemberPair otherPair = (MemberPair)obj;
            return this.srcMemberId.equals(otherPair.srcMemberId) && this.dstMemberId.equals(otherPair.dstMemberId);
        }

        public String toString() {
            return "MemberPair(srcMemberId='" + this.srcMemberId + '\'' + ", dstMemberId='" + this.dstMemberId + '\'' + ')';
        }
    }
}

