/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.FutureCallback;
import org.apache.kafka.connect.util.TopicAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBasedLog<K, V> {
    private static final Logger log = LoggerFactory.getLogger(KafkaBasedLog.class);
    private static final long CREATE_TOPIC_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(30L);
    private static final long MAX_SLEEP_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final Duration ADMIN_CLIENT_RETRY_DURATION = Duration.ofMinutes(15L);
    private static final long ADMIN_CLIENT_RETRY_BACKOFF_MS = TimeUnit.SECONDS.toMillis(10L);
    private final Time time;
    private final String topic;
    private int partitionCount;
    private final Map<String, Object> producerConfigs;
    private final Map<String, Object> consumerConfigs;
    private final Callback<ConsumerRecord<K, V>> consumedCallback;
    private final Supplier<TopicAdmin> topicAdminSupplier;
    private final boolean requireAdminForOffsets;
    private Consumer<K, V> consumer;
    private Optional<Producer<K, V>> producer;
    private TopicAdmin admin;
    Thread thread;
    private boolean stopRequested;
    private final Queue<Callback<Void>> readLogEndOffsetCallbacks;
    private final java.util.function.Consumer<TopicAdmin> initializer;
    private volatile boolean reportErrorsToCallback = false;

    @Deprecated
    public KafkaBasedLog(String topic, Map<String, Object> producerConfigs, Map<String, Object> consumerConfigs, Callback<ConsumerRecord<K, V>> consumedCallback, Time time, Runnable initializer) {
        this(topic, producerConfigs, consumerConfigs, () -> null, consumedCallback, time, initializer != null ? admin -> initializer.run() : null);
    }

    public KafkaBasedLog(String topic, Map<String, Object> producerConfigs, Map<String, Object> consumerConfigs, Supplier<TopicAdmin> topicAdminSupplier, Callback<ConsumerRecord<K, V>> consumedCallback, Time time, java.util.function.Consumer<TopicAdmin> initializer) {
        this.topic = topic;
        this.producerConfigs = producerConfigs;
        this.consumerConfigs = consumerConfigs;
        this.topicAdminSupplier = Objects.requireNonNull(topicAdminSupplier);
        this.consumedCallback = consumedCallback;
        this.stopRequested = false;
        this.readLogEndOffsetCallbacks = new ArrayDeque<Callback<Void>>();
        this.time = time;
        this.initializer = initializer != null ? initializer : admin -> {};
        this.producer = Optional.empty();
        this.requireAdminForOffsets = IsolationLevel.READ_COMMITTED.toString().equals(consumerConfigs.get("isolation.level"));
    }

    public static <K, V> KafkaBasedLog<K, V> withExistingClients(String topic, final Consumer<K, V> consumer, final Producer<K, V> producer, TopicAdmin topicAdmin, Callback<ConsumerRecord<K, V>> consumedCallback, Time time, java.util.function.Consumer<TopicAdmin> initializer, final Predicate<TopicPartition> readTopicPartition) {
        Objects.requireNonNull(topicAdmin);
        Objects.requireNonNull(readTopicPartition);
        return new KafkaBasedLog<K, V>(topic, Collections.emptyMap(), Collections.emptyMap(), () -> topicAdmin, consumedCallback, time, initializer){

            @Override
            protected Producer<K, V> createProducer() {
                return producer;
            }

            @Override
            protected Consumer<K, V> createConsumer() {
                return consumer;
            }

            @Override
            protected boolean readPartition(TopicPartition topicPartition) {
                return readTopicPartition.test(topicPartition);
            }

            @Override
            public void stop() {
                super.stop();
                Utils.closeQuietly((AutoCloseable)producer, (String)"producer");
                Utils.closeQuietly((AutoCloseable)consumer, (String)"consumer");
            }
        };
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean reportErrorsToCallback) {
        this.reportErrorsToCallback = reportErrorsToCallback;
        log.info("Starting KafkaBasedLog with topic {} reportErrorsToCallback={}", (Object)this.topic, (Object)reportErrorsToCallback);
        this.admin = this.topicAdminSupplier.get();
        if (this.admin == null && this.requireAdminForOffsets) {
            throw new ConnectException("Must provide a TopicAdmin to KafkaBasedLog when consumer is configured with isolation.level set to " + IsolationLevel.READ_COMMITTED);
        }
        this.initializer.accept(this.admin);
        this.producer = Optional.ofNullable(this.createProducer());
        if (!this.producer.isPresent()) {
            log.trace("Creating read-only KafkaBasedLog for topic " + this.topic);
        }
        this.consumer = this.createConsumer();
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        List partitionInfos = this.consumer.partitionsFor(this.topic);
        long started = this.time.nanoseconds();
        long sleepMs = 100L;
        while (partitionInfos.isEmpty() && this.time.nanoseconds() - started < CREATE_TOPIC_TIMEOUT_NS) {
            this.time.sleep(sleepMs);
            sleepMs = Math.min(2L * sleepMs, MAX_SLEEP_MS);
            partitionInfos = this.consumer.partitionsFor(this.topic);
        }
        if (partitionInfos.isEmpty()) {
            throw new ConnectException("Could not look up partition metadata for topic '" + this.topic + "' in the allotted period. This could indicate a connectivity issue, unavailable topic partitions, or if this is your first use of the topic it may have taken too long to create.");
        }
        for (PartitionInfo partition : partitionInfos) {
            TopicPartition topicPartition = new TopicPartition(partition.topic(), partition.partition());
            if (!this.readPartition(topicPartition)) continue;
            partitions.add(topicPartition);
        }
        if (partitions.isEmpty()) {
            throw new ConnectException("Some partitions for " + this.topic + " exist, but no partitions matched the required filter.");
        }
        this.partitionCount = partitions.size();
        this.consumer.assign(partitions);
        this.consumer.seekToBeginning(partitions);
        this.readToLogEnd(true);
        this.thread = new WorkThread();
        this.thread.start();
        log.info("Finished reading KafkaBasedLog for topic " + this.topic);
        log.info("Started KafkaBasedLog for topic " + this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.info("Stopping KafkaBasedLog for topic " + this.topic);
        KafkaBasedLog kafkaBasedLog = this;
        synchronized (kafkaBasedLog) {
            this.stopRequested = true;
        }
        if (this.consumer != null) {
            this.consumer.wakeup();
        }
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                throw new ConnectException("Failed to stop KafkaBasedLog. Exiting without cleanly shutting down it's producer and consumer.", (Throwable)e);
            }
        }
        this.producer.ifPresent(p -> Utils.closeQuietly((AutoCloseable)p, (String)("KafkaBasedLog producer for topic " + this.topic)));
        Utils.closeQuietly(this.consumer, (String)("KafkaBasedLog consumer for topic " + this.topic));
        this.admin = null;
        log.info("Stopped KafkaBasedLog for topic " + this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readToEnd(Callback<Void> callback) {
        log.trace("Starting read to end log for topic {}", (Object)this.topic);
        this.flush();
        KafkaBasedLog kafkaBasedLog = this;
        synchronized (kafkaBasedLog) {
            this.readLogEndOffsetCallbacks.add(callback);
        }
        this.consumer.wakeup();
    }

    public void flush() {
        this.producer.ifPresent(Producer::flush);
    }

    public Future<Void> readToEnd() {
        FutureCallback<Void> future = new FutureCallback<Void>(null);
        this.readToEnd(future);
        return future;
    }

    public void send(K key, V value) {
        this.sendWithReceipt(key, value);
    }

    public void send(K key, V value, org.apache.kafka.clients.producer.Callback callback) {
        this.sendWithReceipt(key, value, callback);
    }

    public Future<RecordMetadata> sendWithReceipt(K key, V value) {
        return this.sendWithReceipt(key, value, null);
    }

    public Future<RecordMetadata> sendWithReceipt(K key, V value, org.apache.kafka.clients.producer.Callback callback) {
        return this.producer.orElseThrow(() -> new IllegalStateException("This KafkaBasedLog was created in read-only mode and does not support write operations")).send(new ProducerRecord(this.topic, key, value), callback);
    }

    public int partitionCount() {
        return this.partitionCount;
    }

    protected Producer<K, V> createProducer() {
        this.producerConfigs.put("acks", "all");
        this.producerConfigs.put("max.in.flight.requests.per.connection", 1);
        return new KafkaProducer(this.producerConfigs);
    }

    protected Consumer<K, V> createConsumer() {
        this.consumerConfigs.put("auto.offset.reset", "earliest");
        this.consumerConfigs.put("enable.auto.commit", false);
        return new KafkaConsumer(this.consumerConfigs);
    }

    protected boolean readPartition(TopicPartition topicPartition) {
        return true;
    }

    private void poll(long timeoutMs) {
        block4: {
            try {
                ConsumerRecords records = this.consumer.poll(Duration.ofMillis(timeoutMs));
                for (ConsumerRecord record : records) {
                    this.consumedCallback.onCompletion(null, record);
                }
            }
            catch (WakeupException e) {
                throw e;
            }
            catch (KafkaException e) {
                log.error("Error polling: " + (Object)((Object)e));
                if (!this.reportErrorsToCallback) break block4;
                this.consumedCallback.onCompletion(e, null);
            }
        }
    }

    private void readToLogEnd(boolean shouldRetry) {
        Set assignment = this.consumer.assignment();
        Map<TopicPartition, Long> endOffsets = this.readEndOffsets(assignment, shouldRetry);
        log.trace("Reading to end of log offsets {}", endOffsets);
        block0: while (!endOffsets.isEmpty()) {
            Iterator<Map.Entry<TopicPartition, Long>> it = endOffsets.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TopicPartition, Long> entry = it.next();
                TopicPartition topicPartition = entry.getKey();
                long endOffset = entry.getValue();
                long lastConsumedOffset = this.consumer.position(topicPartition);
                if (lastConsumedOffset >= endOffset) {
                    log.trace("Read to end offset {} for {}", (Object)endOffset, (Object)topicPartition);
                    it.remove();
                    continue;
                }
                log.trace("Behind end offset {} for {}; last-read offset is {}", new Object[]{endOffset, topicPartition, lastConsumedOffset});
                this.poll(Integer.MAX_VALUE);
                continue block0;
            }
        }
    }

    Map<TopicPartition, Long> readEndOffsets(Set<TopicPartition> assignment, boolean shouldRetry) throws UnsupportedVersionException {
        log.trace("Reading to end of offset log");
        if (this.admin != null) {
            try {
                if (shouldRetry) {
                    return this.admin.retryEndOffsets(assignment, ADMIN_CLIENT_RETRY_DURATION, ADMIN_CLIENT_RETRY_BACKOFF_MS);
                }
                return this.admin.endOffsets(assignment);
            }
            catch (UnsupportedVersionException e) {
                if (this.requireAdminForOffsets) {
                    throw e;
                }
                log.debug("Reading to end of log offsets with consumer since admin client is unsupported: {}", (Object)e.getMessage());
                this.admin = null;
            }
        }
        return this.consumer.endOffsets(assignment);
    }

    private class WorkThread
    extends Thread {
        public WorkThread() {
            super("KafkaBasedLog Work Thread - " + KafkaBasedLog.this.topic);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                log.trace("{} started execution", (Object)this);
                while (true) {
                    int numCallbacks;
                    KafkaBasedLog kafkaBasedLog = KafkaBasedLog.this;
                    synchronized (kafkaBasedLog) {
                        if (KafkaBasedLog.this.stopRequested) {
                            break;
                        }
                        numCallbacks = KafkaBasedLog.this.readLogEndOffsetCallbacks.size();
                    }
                    if (numCallbacks > 0) {
                        try {
                            KafkaBasedLog.this.readToLogEnd(false);
                            log.trace("Finished read to end log for topic {}", (Object)KafkaBasedLog.this.topic);
                        }
                        catch (TimeoutException e) {
                            log.warn("Timeout while reading log to end for topic '{}'. Retrying automatically. This may occur when brokers are unavailable or unreachable. Reason: {}", (Object)KafkaBasedLog.this.topic, (Object)e.getMessage());
                            continue;
                        }
                        catch (org.apache.kafka.common.errors.RetriableException | RetriableException e) {
                            log.warn("Retriable error while reading log to end for topic '{}'. Retrying automatically. Reason: {}", (Object)KafkaBasedLog.this.topic, (Object)e.getMessage());
                            continue;
                        }
                        catch (WakeupException e) {
                            continue;
                        }
                    }
                    KafkaBasedLog e = KafkaBasedLog.this;
                    synchronized (e) {
                        for (int i = 0; i < numCallbacks; ++i) {
                            Callback cb = (Callback)KafkaBasedLog.this.readLogEndOffsetCallbacks.poll();
                            cb.onCompletion(null, null);
                        }
                    }
                    try {
                        KafkaBasedLog.this.poll(Integer.MAX_VALUE);
                    }
                    catch (WakeupException e2) {}
                }
            }
            catch (Throwable t) {
                log.error("Unexpected exception in {}", (Object)this, (Object)t);
            }
        }
    }
}

