/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl.vars;

import java.util.regex.Pattern;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.svl.MultipartVar;
import org.apache.juneau.svl.VarResolverSession;

public class LenVar
extends MultipartVar {
    public static final String NAME = "LN";

    public LenVar() {
        super(NAME);
    }

    @Override
    public String resolve(VarResolverSession session, String[] args) {
        ArgUtils.assertArg(args.length <= 2, "Invalid number of arguments passed to $LN var.  Must have 1 or 2 arguments.", new Object[0]);
        int len = 0;
        String stringArg = args[0];
        if (args.length == 1) {
            len = stringArg.length();
        } else if (args.length == 2) {
            String delimiter = Pattern.quote(args[1]);
            len = stringArg.trim().split(delimiter).length;
        }
        return String.valueOf(len);
    }
}

