/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.stats;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.stats.MethodExecStats;

public class MethodInvoker {
    private final MethodInfo m;
    private final MethodExecStats stats;

    public MethodInvoker(Method m, MethodExecStats stats) {
        this.m = MethodInfo.of(m);
        this.stats = stats;
    }

    public MethodInfo inner() {
        return this.m;
    }

    public Object invoke(Object o, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        long startTime = System.nanoTime();
        this.stats.started();
        try {
            Object object = this.m.inner().invoke(o, args);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.stats.error(e);
            throw e;
        }
        catch (InvocationTargetException e) {
            this.stats.error(e.getTargetException());
            throw e;
        }
        finally {
            this.stats.finished(System.nanoTime() - startTime);
        }
    }

    public Object invoke(BeanStore beanStore, Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (beanStore.hasAllParams(this.m)) {
            return this.invoke(o, beanStore.getParams(this.m));
        }
        throw new IllegalArgumentException("Could not find prerequisites to invoke method '" + this.getFullName() + "': " + beanStore.getMissingParams(this.m));
    }

    public ClassInfo getDeclaringClass() {
        return this.m.getDeclaringClass();
    }

    public String getFullName() {
        return this.m.getFullName();
    }

    public MethodExecStats getStats() {
        return this.stats;
    }
}

