/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="authorizationUrl,tokenUrl,refreshUrl,scopes,*")
@FluentSetters
public class OAuthFlow
extends OpenApiElement {
    private String authorizationUrl;
    private String tokenUrl;
    private String refreshUrl;
    private Map<String, String> scopes;

    public OAuthFlow() {
    }

    public OAuthFlow(OAuthFlow copyFrom) {
        super(copyFrom);
        this.authorizationUrl = copyFrom.authorizationUrl;
        this.tokenUrl = copyFrom.tokenUrl;
        this.refreshUrl = copyFrom.refreshUrl;
        this.scopes = copyFrom.scopes == null ? null : new LinkedHashMap<String, String>(copyFrom.scopes);
    }

    public OAuthFlow copy() {
        return new OAuthFlow(this);
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public OAuthFlow setAuthorizationUrl(String value) {
        this.authorizationUrl = value;
        return this;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public OAuthFlow setTokenUrl(String value) {
        this.tokenUrl = value;
        return this;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public OAuthFlow setRefreshUrl(String value) {
        this.refreshUrl = value;
        return this;
    }

    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public OAuthFlow setScopes(Map<String, String> value) {
        this.scopes = CollectionUtils.copyOf(value);
        return this;
    }

    public OAuthFlow addScope(String name, String description) {
        this.scopes = CollectionUtils.mapBuilder(this.scopes).sparse().add(name, description).build();
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "refreshUrl": {
                return ConverterUtils.toType(this.getRefreshUrl(), type);
            }
            case "tokenUrl": {
                return ConverterUtils.toType(this.getTokenUrl(), type);
            }
            case "authorizationUrl": {
                return ConverterUtils.toType(this.getAuthorizationUrl(), type);
            }
            case "scopes": {
                return ConverterUtils.toType(this.getScopes(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public OAuthFlow set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "authorizationUrl": {
                return this.setAuthorizationUrl(StringUtils.stringify(value));
            }
            case "tokenUrl": {
                return this.setTokenUrl(StringUtils.stringify(value));
            }
            case "refreshUrl": {
                return this.setRefreshUrl(StringUtils.stringify(value));
            }
            case "scopes": {
                return this.setScopes(CollectionUtils.mapBuilder(String.class, String.class, new Type[0]).sparse().addAny(value).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.authorizationUrl != null, "authorizationUrl").addIf(this.tokenUrl != null, "tokenUrl").addIf(this.refreshUrl != null, "refreshUrl").addIf(this.scopes != null, "scopes").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

