/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;

@Bean(properties="enum,default,description,*")
@FluentSetters
public class ServerVariable
extends OpenApiElement {
    private List<Object> _enum;
    private String _default;
    private String description;

    public ServerVariable() {
    }

    public ServerVariable(ServerVariable copyFrom) {
        super(copyFrom);
        this._enum = CollectionUtils.copyOf(copyFrom._enum);
        this._default = copyFrom._default;
        this.description = copyFrom.description;
    }

    public ServerVariable copy() {
        return new ServerVariable(this);
    }

    @Override
    protected ServerVariable strict() {
        super.strict();
        return this;
    }

    public List<Object> getEnum() {
        return this._enum;
    }

    public ServerVariable setEnum(Collection<Object> value) {
        this._enum = CollectionUtils.listFrom(value);
        return this;
    }

    public ServerVariable addEnum(Object ... values) {
        this._enum = CollectionUtils.listBuilder(this._enum).sparse().addAny(values).build();
        return this;
    }

    public String getDefault() {
        return this._default;
    }

    public ServerVariable setDefault(String value) {
        this._default = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ServerVariable setDescription(String value) {
        this.description = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "enum": {
                return (T)ConverterUtils.toType(this.getEnum(), type);
            }
            case "default": {
                return (T)ConverterUtils.toType((Object)this.getDefault(), type);
            }
            case "description": {
                return (T)ConverterUtils.toType((Object)this.getDescription(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public ServerVariable set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "default": {
                return this.setDefault(StringUtils.stringify((Object)value));
            }
            case "enum": {
                return this.setEnum(CollectionUtils.listBuilder(Object.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "description": {
                return this.setDescription(StringUtils.stringify((Object)value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).addIf(this._enum != null, (Object)"enum").addIf(this._default != null, (Object)"default").addIf(this.description != null, (Object)"description").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }
}

