/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logging;

import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.Enablement;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.SystemEnv;
import org.apache.juneau.rest.logging.BasicRestLogger;
import org.apache.juneau.rest.logging.RestLoggerRule;
import org.apache.juneau.rest.logging.RestLoggingDetail;
import org.apache.juneau.rest.stats.ThrownStore;

public interface RestLogger {
    public static final String SP_logger = "juneau.restLogger.logger";
    public static final String SP_enabled = "juneau.restLogger.enabled";
    public static final String SP_requestDetail = "juneau.restLogger.requestDetail";
    public static final String SP_responseDetail = "juneau.restLogger.responseDetail";
    public static final String SP_level = "juneau.restLogger.level";

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public void log(HttpServletRequest var1, HttpServletResponse var2);

    @FluentSetters
    public static class Builder
    extends BeanBuilder<RestLogger> {
        Logger logger;
        ThrownStore thrownStore;
        List<RestLoggerRule> normalRules = CollectionUtils.list(new RestLoggerRule[0]);
        List<RestLoggerRule> debugRules = CollectionUtils.list(new RestLoggerRule[0]);
        Enablement enabled;
        Predicate<HttpServletRequest> enabledTest;
        RestLoggingDetail requestDetail;
        RestLoggingDetail responseDetail;
        Level level;

        protected Builder(BeanStore beanStore) {
            super(BasicRestLogger.class, beanStore);
            this.logger = Logger.getLogger(SystemEnv.env(RestLogger.SP_logger, "global"));
            this.enabled = SystemEnv.env(RestLogger.SP_enabled, Enablement.ALWAYS);
            this.enabledTest = x -> false;
            this.requestDetail = SystemEnv.env(RestLogger.SP_requestDetail, RestLoggingDetail.STATUS_LINE);
            this.responseDetail = SystemEnv.env(RestLogger.SP_responseDetail, RestLoggingDetail.STATUS_LINE);
            this.level = SystemEnv.env(RestLogger.SP_level).map(Level::parse).orElse(Level.OFF);
        }

        @Override
        protected RestLogger buildDefault() {
            return new BasicRestLogger(this);
        }

        @Override
        protected BeanCreator<? extends RestLogger> creator() {
            return super.creator();
        }

        public Builder logger(Logger value) {
            this.logger = value;
            return this;
        }

        public Builder logger(String value) {
            this.logger = value == null ? null : Logger.getLogger(value);
            return this;
        }

        public Builder loggerOnce(Logger value) {
            if (this.logger == null) {
                this.logger = value;
            }
            return this;
        }

        public Builder thrownStore(ThrownStore value) {
            this.thrownStore = value;
            return this;
        }

        public Builder thrownStoreOnce(ThrownStore value) {
            if (this.thrownStore == null) {
                this.thrownStore = value;
            }
            return this;
        }

        public Builder enabled(Enablement value) {
            this.enabled = value;
            return this;
        }

        public Builder enabledTest(Predicate<HttpServletRequest> value) {
            this.enabledTest = value;
            return this;
        }

        public Builder disabled() {
            return this.enabled(Enablement.NEVER);
        }

        public Builder requestDetail(RestLoggingDetail value) {
            this.requestDetail = value;
            return this;
        }

        public Builder responseDetail(RestLoggingDetail value) {
            this.responseDetail = value;
            return this;
        }

        public Builder level(Level value) {
            this.level = value;
            return this;
        }

        public Builder normalRules(RestLoggerRule ... values) {
            for (RestLoggerRule rule : values) {
                this.normalRules.add(rule);
            }
            return this;
        }

        public Builder debugRules(RestLoggerRule ... values) {
            for (RestLoggerRule rule : values) {
                this.debugRules.add(rule);
            }
            return this;
        }

        public Builder rules(RestLoggerRule ... values) {
            return this.normalRules(values).debugRules(values);
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }

    public static abstract class Void
    implements RestLogger {
    }
}

