/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import org.apache.http.NameValuePair;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHttpPart;

public class RequestPathParam
extends RequestHttpPart
implements NameValuePair {
    private final String value;

    public RequestPathParam(RestRequest request, String name, String value) {
        super(HttpPartType.PATH, request, name);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public FluentStringAssertion<RequestPathParam> assertString() {
        return new FluentStringAssertion<RequestPathParam>(this.orElse(null), this);
    }

    public FluentIntegerAssertion<RequestPathParam> assertInteger() {
        return new FluentIntegerAssertion<RequestPathParam>(this.asIntegerPart().asInteger().orElse(null), this);
    }

    public FluentLongAssertion<RequestPathParam> assertLong() {
        return new FluentLongAssertion<RequestPathParam>(this.asLongPart().asLong().orElse(null), this);
    }

    public FluentZonedDateTimeAssertion<RequestPathParam> assertDate() {
        return new FluentZonedDateTimeAssertion<RequestPathParam>(this.asDatePart().asZonedDateTime().orElse(null), this);
    }

    public FluentListAssertion<String, RequestPathParam> assertCsvArray() {
        return new FluentListAssertion<String, RequestPathParam>(this.asCsvArrayPart().asList().orElse(null), this);
    }

    @Override
    public RequestPathParam schema(HttpPartSchema value) {
        super.schema(value);
        return this;
    }

    @Override
    public RequestPathParam parser(HttpPartParserSession value) {
        super.parser(value);
        return this;
    }
}

