/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.assertion;

import java.io.PrintStream;
import java.lang.reflect.Type;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.rest.client.ResponseHeader;
import org.apache.juneau.rest.client.RestCallException;

@FluentSetters(returns="FluentResponseHeaderAssertion<R>")
public class FluentResponseHeaderAssertion<R>
extends FluentStringAssertion<R> {
    private final ResponseHeader value;

    public FluentResponseHeaderAssertion(ResponseHeader value, R returns) {
        this((Assertion)null, value, returns);
    }

    public FluentResponseHeaderAssertion(Assertion creator, ResponseHeader value, R returns) {
        super(creator, (String)value.asString().orElse(null), returns);
        this.value = value;
        this.setThrowable(BadRequest.class);
    }

    public FluentBooleanAssertion<R> asBoolean() {
        return new FluentBooleanAssertion((Assertion)this, this.value.asBoolean().orElse(null), this.returns());
    }

    public FluentIntegerAssertion<R> asInteger() {
        return new FluentIntegerAssertion((Assertion)this, this.value.asInteger().orElse(null), this.returns());
    }

    public FluentLongAssertion<R> asLong() {
        return new FluentLongAssertion((Assertion)this, this.value.asLong().orElse(null), this.returns());
    }

    public FluentZonedDateTimeAssertion<R> asZonedDateTime() {
        return new FluentZonedDateTimeAssertion((Assertion)this, this.value.asDateHeader().asZonedDateTime().orElse(null), this.returns());
    }

    public <T> FluentAnyAssertion<T, R> as(Class<T> type) throws RestCallException {
        return new FluentAnyAssertion(this.value.as(type).orElse(null), this.returns());
    }

    public FluentAnyAssertion<Object, R> as(Type type, Type ... args) throws RestCallException {
        return new FluentAnyAssertion(this.value.as(type, args).orElse(null), this.returns());
    }

    @Override
    public FluentResponseHeaderAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentResponseHeaderAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentResponseHeaderAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentResponseHeaderAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentResponseHeaderAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    @Override
    public FluentResponseHeaderAssertion<R> asJavaStrings() {
        super.asJavaStrings();
        return this;
    }
}

