/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.logging.Level;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.pojotools.Matcher;
import org.apache.juneau.pojotools.NumberMatcherFactory;
import org.apache.juneau.pojotools.StringMatcherFactory;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.RestCallLoggingDetail;

public class RestCallLoggerRule {
    private final Matcher codeMatcher;
    private final Matcher exceptionMatcher;
    private final boolean debugOnly;
    private final Level level;
    private final Enablement disabled;
    private final RestCallLoggingDetail req;
    private final RestCallLoggingDetail res;

    RestCallLoggerRule(Builder b) {
        this.codeMatcher = StringUtils.isEmpty(b.codes) || "*".equals(b.codes) ? null : NumberMatcherFactory.DEFAULT.create(b.codes);
        this.exceptionMatcher = StringUtils.isEmpty(b.exceptions) ? null : StringMatcherFactory.DEFAULT.create(b.exceptions);
        boolean verbose = b.verbose == null ? false : b.verbose;
        this.disabled = b.disabled;
        this.debugOnly = b.debugOnly == null ? false : b.debugOnly;
        this.level = b.level;
        RestCallLoggingDetail restCallLoggingDetail = verbose ? RestCallLoggingDetail.LONG : (this.req = b.req != null ? b.req : RestCallLoggingDetail.SHORT);
        this.res = verbose ? RestCallLoggingDetail.LONG : (b.res != null ? b.res : RestCallLoggingDetail.SHORT);
    }

    public static Builder create() {
        return new Builder();
    }

    public boolean matches(int statusCode, boolean debug, Throwable e) {
        if (this.debugOnly && !debug) {
            return false;
        }
        if (this.exceptionMatcher != null) {
            if (e == null) {
                return false;
            }
            Class<?> c = e.getClass();
            if (!this.exceptionMatcher.matches(null, c.getName()) && !this.exceptionMatcher.matches(null, c.getSimpleName())) {
                return false;
            }
        }
        return this.codeMatcher == null || this.codeMatcher.matches(null, statusCode);
    }

    public RestCallLoggingDetail getReqDetail() {
        return this.req;
    }

    public RestCallLoggingDetail getResDetail() {
        return this.res;
    }

    public Level getLevel() {
        return this.level;
    }

    public Enablement getDisabled() {
        return this.disabled;
    }

    private OMap toMap() {
        return new DefaultFilteringOMap().append("codes", this.codeMatcher).append("exceptions", this.exceptionMatcher).append("debugOnly", this.debugOnly).append("level", this.level).append("req", (Object)(this.req == RestCallLoggingDetail.SHORT ? null : this.req)).append("res", (Object)(this.res == RestCallLoggingDetail.SHORT ? null : this.res));
    }

    public String toString() {
        return SimpleJsonSerializer.DEFAULT.toString(this.toMap());
    }

    @Bean(fluentSetters=true)
    public static class Builder {
        String codes;
        String exceptions;
        Boolean verbose;
        Boolean debugOnly;
        Enablement disabled;
        Level level;
        RestCallLoggingDetail req;
        RestCallLoggingDetail res;

        public Builder codes(String value) {
            this.codes = value;
            String c = StringUtils.emptyIfNull(StringUtils.trim(this.codes));
            if (c.endsWith("-")) {
                this.codes = this.codes + "999";
            } else if (c.startsWith("-")) {
                this.codes = "0" + this.codes;
            }
            return this;
        }

        public Builder exceptions(String value) {
            this.exceptions = value;
            return this;
        }

        public Builder verbose(Boolean value) {
            this.verbose = value;
            return this;
        }

        public Builder verbose() {
            return this.verbose(true);
        }

        public Builder disabled(Enablement value) {
            this.disabled = value;
            return this;
        }

        public Builder disabled() {
            return this.disabled(Enablement.TRUE);
        }

        public Builder debugOnly(Boolean value) {
            this.debugOnly = value;
            return this;
        }

        public Builder debugOnly() {
            return this.debugOnly(true);
        }

        public Builder req(RestCallLoggingDetail value) {
            this.req = value;
            return this;
        }

        public Builder res(RestCallLoggingDetail value) {
            this.res = value;
            return this;
        }

        public Builder level(Level value) {
            this.level = value;
            return this;
        }

        public RestCallLoggerRule build() {
            return new RestCallLoggerRule(this);
        }
    }
}

