/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.config.store.ConfigMemoryStoreBuilder;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.internal.StringUtils;

@ConfigurableContext
public class ConfigMemoryStore
extends ConfigStore {
    static final String PREFIX = "ConfigMemoryStore";
    public static final ConfigMemoryStore DEFAULT = ConfigMemoryStore.create().build();
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();

    public static ConfigMemoryStoreBuilder create() {
        return new ConfigMemoryStoreBuilder();
    }

    @Override
    public ConfigMemoryStoreBuilder builder() {
        return new ConfigMemoryStoreBuilder(this.getPropertyStore());
    }

    protected ConfigMemoryStore(PropertyStore ps) {
        super(ps);
    }

    @Override
    public synchronized String read(String name) {
        return StringUtils.emptyIfNull(this.cache.get(name));
    }

    @Override
    public synchronized String write(String name, String expectedContents, String newContents) {
        if (StringUtils.isEquals(expectedContents, newContents)) {
            return null;
        }
        String currentContents = this.read(name);
        if (expectedContents != null && !StringUtils.isEquals(currentContents, expectedContents)) {
            return currentContents;
        }
        this.update(name, newContents);
        return null;
    }

    @Override
    public synchronized boolean exists(String name) {
        return this.cache.containsKey(name);
    }

    @Override
    public synchronized ConfigMemoryStore update(String name, String newContents) {
        if (newContents == null) {
            this.cache.remove(name);
        } else {
            this.cache.put(name, newContents);
        }
        super.update(name, newContents);
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap());
    }
}

