/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.Headerable;
import org.apache.juneau.http.NameValuePairable;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;

@BeanIgnore
public class BasicNameValuePair
implements NameValuePair,
Headerable {
    private final String name;
    private final Object value;

    public static BasicNameValuePair of(String name, Object value) {
        return new BasicNameValuePair(name, value);
    }

    public static BasicNameValuePair ofPair(String pair) {
        if (pair == null) {
            return null;
        }
        int i = pair.indexOf(58);
        if (i == -1) {
            return BasicNameValuePair.of(pair, "");
        }
        return BasicNameValuePair.of(pair.substring(0, i).trim(), pair.substring(i + 1).trim());
    }

    public static BasicNameValuePair of(String name, Supplier<?> value) {
        return new BasicNameValuePair(name, value);
    }

    public static NameValuePair cast(Object o) {
        if (o instanceof NameValuePair) {
            return (NameValuePair)o;
        }
        if (o instanceof NameValuePairable) {
            return ((NameValuePairable)o).asNameValuePair();
        }
        if (o instanceof Headerable) {
            return ((Headerable)o).asHeader();
        }
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return BasicNameValuePair.of(StringUtils.stringify(e.getKey()), e.getValue());
        }
        throw new BasicRuntimeException("Object of type {0} could not be converted to a NameValuePair.", o == null ? null : o.getClass().getName());
    }

    public static boolean canCast(Object o) {
        ClassInfo ci = ClassInfo.of(o);
        return ci != null && ci.isChildOfAny(Headerable.class, NameValuePair.class, NameValuePairable.class, Map.Entry.class);
    }

    public BasicNameValuePair(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public FluentStringAssertion<BasicNameValuePair> assertName() {
        return new FluentStringAssertion<BasicNameValuePair>(this.getName(), this);
    }

    public FluentStringAssertion<BasicNameValuePair> assertValue() {
        return new FluentStringAssertion<BasicNameValuePair>(this.getValue(), this);
    }

    @Override
    public BasicHeader asHeader() {
        return BasicHeader.of(this.name, this.value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return StringUtils.stringify(this.unwrap(this.value));
    }

    public String toString() {
        return StringUtils.urlEncode(this.getName()) + "=" + StringUtils.urlEncode(this.getValue());
    }

    private Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }
}

