/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.rest.util.CachingHttpServletResponse;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathInfo;
import org.apache.juneau.rest.util.UrlPathPatternMatch;

public class RestCall {
    private static final String REST_PATHVARS_ATTR = "juneau.pathVars";
    private HttpServletRequest req;
    private HttpServletResponse res;
    private RestRequest rreq;
    private RestResponse rres;
    private RestContext context;
    private RestMethodContext rmethod;
    private UrlPathInfo urlPathInfo;
    private String pathInfoUndecoded;
    private long startTime = System.currentTimeMillis();
    private RestCallLogger logger;
    private RestCallLoggerConfig loggerConfig;
    private UrlPathPatternMatch urlPathPatternMatch;

    public RestCall(RestContext context, HttpServletRequest req, HttpServletResponse res) {
        this.context(context).request(req).response(res);
    }

    public RestCall request(HttpServletRequest req) {
        this.req = req;
        this.urlPathInfo = null;
        this.pathInfoUndecoded = null;
        return this;
    }

    public RestCall response(HttpServletResponse res) {
        this.res = res;
        return this;
    }

    public RestCall context(RestContext context) {
        this.context = context;
        return this;
    }

    public RestCall restMethodContext(RestMethodContext value) {
        this.rmethod = value;
        return this;
    }

    public RestCall restRequest(RestRequest rreq) {
        this.request((HttpServletRequest)rreq);
        this.rreq = rreq;
        return this;
    }

    public RestCall restResponse(RestResponse rres) {
        this.response((HttpServletResponse)rres);
        this.rres = rres;
        this.rreq.setResponse(rres);
        return this;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public RestRequest getRestRequest() {
        return this.rreq;
    }

    public RestResponse getRestResponse() {
        return this.rres;
    }

    public RestMethodContext getRestMethodContext() {
        return this.rmethod;
    }

    public Method getJavaMethod() {
        return this.rmethod == null ? null : this.rmethod.method;
    }

    public void addPathVars(Map<String, String> vars) {
        if (vars != null && !vars.isEmpty()) {
            TreeMap<String, String> m = (TreeMap<String, String>)this.req.getAttribute(REST_PATHVARS_ATTR);
            if (m == null) {
                m = new TreeMap<String, String>();
                this.req.setAttribute(REST_PATHVARS_ATTR, m);
            }
            m.putAll(vars);
        }
    }

    public Map<String, String> getPathVars() {
        Map m = (Map)this.req.getAttribute(REST_PATHVARS_ATTR);
        return m == null ? Collections.emptyMap() : m;
    }

    public RestCall logger(RestCallLogger logger) {
        this.logger = logger;
        return this;
    }

    public RestCall loggerConfig(RestCallLoggerConfig config) {
        this.loggerConfig = config;
        return this;
    }

    public RestCall debug(boolean b) throws IOException {
        if (b) {
            this.req = CachingHttpServletRequest.wrap(this.req);
            this.res = CachingHttpServletResponse.wrap(this.res);
            this.req.setAttribute("Debug", (Object)true);
        } else {
            this.req.removeAttribute("Debug");
        }
        return this;
    }

    public RestCall status(int code) {
        this.res.setStatus(code);
        return this;
    }

    public RestCall exception(Throwable e) {
        this.req.setAttribute("Exception", (Object)e);
        return this;
    }

    public RestCall responseMeta(ResponseBeanMeta meta) {
        if (this.rres != null) {
            this.rres.setResponseMeta(meta);
        }
        return this;
    }

    public RestCall output(Object output) {
        if (this.rres != null) {
            this.rres.setOutput(output);
        }
        return this;
    }

    public RestCall urlPathPatternMatch(UrlPathPatternMatch urlPathPatternMatch) {
        this.urlPathPatternMatch = urlPathPatternMatch;
        return this;
    }

    public UrlPathPatternMatch getUrlPathPatternMatch() {
        return this.urlPathPatternMatch;
    }

    public RestCall finish() {
        try {
            this.res.flushBuffer();
            this.req.setAttribute("ExecTime", (Object)(System.currentTimeMillis() - this.startTime));
            if (this.rreq != null) {
                this.rreq.close();
            }
        }
        catch (Exception e) {
            this.exception(e);
        }
        if (this.logger != null) {
            this.logger.log(this.loggerConfig, this.req, this.res);
        }
        return this;
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public UrlPathInfo getUrlPathInfo() {
        if (this.urlPathInfo == null) {
            this.urlPathInfo = new UrlPathInfo(this.getPathInfoUndecoded());
        }
        return this.urlPathInfo;
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathInfoUndecoded() {
        if (this.pathInfoUndecoded == null) {
            this.pathInfoUndecoded = RestUtils.getPathInfoUndecoded(this.req);
        }
        return this.pathInfoUndecoded;
    }

    public String getMethod() {
        if (this.rreq != null) {
            return this.rreq.getMethod().toUpperCase(Locale.ENGLISH);
        }
        return this.req.getMethod().toUpperCase(Locale.ENGLISH);
    }

    public int getStatus() {
        return this.res.getStatus();
    }

    public boolean hasOutput() {
        if (this.rres != null) {
            return this.rres.hasOutput();
        }
        return false;
    }

    public Object getOutput() {
        if (this.rres != null) {
            return this.rres.getOutput();
        }
        return null;
    }

    public boolean isDebug() {
        if (this.rreq != null) {
            return this.rreq.isDebug();
        }
        return false;
    }

    public RestContext getContext() {
        return this.context;
    }
}

