/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.ContextCache;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.svl.VarResolverSession;

public class ParserGroupBuilder
extends BeanContextBuilder {
    private final List<Object> parsers = new ArrayList<Object>();

    public ParserGroupBuilder() {
    }

    public ParserGroupBuilder(ParserGroup copyFrom) {
        super(copyFrom.getPropertyStore());
        CollectionUtils.addReverse(this.parsers, copyFrom.getParsers());
    }

    public ParserGroupBuilder append(Class<?> ... p) {
        CollectionUtils.addReverse(this.parsers, p);
        return this;
    }

    public ParserGroupBuilder append(Parser ... p) {
        CollectionUtils.addReverse(this.parsers, p);
        return this;
    }

    public ParserGroupBuilder append(List<Object> p) {
        CollectionUtils.addReverse(this.parsers, p);
        return this;
    }

    public ParserGroupBuilder append(Object ... p) {
        CollectionUtils.addReverse(this.parsers, p);
        return this;
    }

    @Override
    public ParserGroup build() {
        ArrayList<Parser> l = new ArrayList<Parser>();
        for (Object p : this.parsers) {
            Class c = null;
            PropertyStore ps = this.getPropertyStore();
            if (p instanceof Class) {
                c = (Class)p;
                l.add((Parser)ContextCache.INSTANCE.create(c, ps));
                continue;
            }
            l.add((Parser)p);
        }
        return new ParserGroup(this.getPropertyStore(), ArrayUtils.toReverseArray(Parser.class, l));
    }

    public ParserGroupBuilder autoCloseStreams(boolean value) {
        return this.set("Parser.autoCloseStreams.b", value);
    }

    public ParserGroupBuilder autoCloseStreams() {
        return this.set("Parser.autoCloseStreams.b", true);
    }

    public ParserGroupBuilder debugOutputLines(int value) {
        this.set("Parser.debugOutputLines.i", value);
        return this;
    }

    public ParserGroupBuilder listener(Class<? extends ParserListener> value) {
        return this.set("Parser.listener.c", value);
    }

    public ParserGroupBuilder strict(boolean value) {
        return this.set("Parser.strict.b", value);
    }

    public ParserGroupBuilder strict() {
        return this.set("Parser.strict.b", true);
    }

    public ParserGroupBuilder trimStrings(boolean value) {
        return this.set("Parser.trimStrings.b", value);
    }

    public ParserGroupBuilder trimStrings() {
        return this.set("Parser.trimStrings.b", true);
    }

    public ParserGroupBuilder unbuffered(boolean value) {
        return this.set("Parser.unbuffered.b", value);
    }

    public ParserGroupBuilder unbuffered() {
        return this.set("Parser.unbuffered.b", true);
    }

    public ParserGroupBuilder fileCharset(Charset value) {
        return this.set("ReaderParser.fileCharset.s", value);
    }

    public ParserGroupBuilder streamCharset(Charset value) {
        return this.set("ReaderParser.streamCharset.s", value);
    }

    public ParserGroupBuilder binaryFormat(BinaryFormat value) {
        return this.set("InputStreamParser.binaryFormat.s", (Object)value);
    }

    @Override
    public ParserGroupBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    @Override
    @Deprecated
    public ParserGroupBuilder beanDictionary(Class<?> ... values) {
        super.beanDictionary(values);
        return this;
    }

    @Override
    @Deprecated
    public ParserGroupBuilder beanDictionary(Object ... values) {
        super.beanDictionary(values);
        return this;
    }

    @Override
    @Deprecated
    public ParserGroupBuilder beanDictionaryReplace(Class<?> ... values) {
        super.beanDictionaryReplace(values);
        return this;
    }

    @Override
    @Deprecated
    public ParserGroupBuilder beanDictionaryReplace(Object ... values) {
        super.beanDictionaryReplace(values);
        return this;
    }

    @Override
    @Deprecated
    public ParserGroupBuilder beanDictionaryRemove(Class<?> ... values) {
        super.beanDictionaryRemove(values);
        return this;
    }

    @Override
    @Deprecated
    public ParserGroupBuilder beanDictionaryRemove(Object ... values) {
        super.beanDictionaryRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beanFilters(Class<?> ... values) {
        super.beanFilters(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanFilters(Object ... values) {
        super.beanFilters(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanFiltersReplace(Class<?> ... values) {
        super.beanFiltersReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanFiltersReplace(Object ... values) {
        super.beanFiltersReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanFiltersRemove(Class<?> ... values) {
        super.beanFiltersRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanFiltersRemove(Object ... values) {
        super.beanFiltersRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanMapPutReturnsOldValue(boolean value) {
        super.beanMapPutReturnsOldValue(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    @Override
    public ParserGroupBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireDefaultConstructor(boolean value) {
        super.beansRequireDefaultConstructor(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireSerializable(boolean value) {
        super.beansRequireSerializable(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireSettersForGetters(boolean value) {
        super.beansRequireSettersForGetters(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireSomeProperties(boolean value) {
        super.beansRequireSomeProperties(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beanTypePropertyName(String value) {
        super.beanTypePropertyName(value);
        return this;
    }

    @Override
    public ParserGroupBuilder bpi(Class<?> beanClass, String value) {
        super.bpi(beanClass, value);
        return this;
    }

    @Override
    public ParserGroupBuilder bpi(Map<String, String> values) {
        super.bpi(values);
        return this;
    }

    @Override
    public ParserGroupBuilder bpi(String beanClassName, String value) {
        super.bpi(beanClassName, value);
        return this;
    }

    @Override
    public ParserGroupBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx(beanClass, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpx(Map<String, String> values) {
        super.bpx(values);
        return this;
    }

    @Override
    public ParserGroupBuilder bpx(String beanClassName, String value) {
        super.bpx(beanClassName, value);
        return this;
    }

    @Override
    public ParserGroupBuilder bpro(Class<?> beanClass, String value) {
        super.bpro(beanClass, value);
        return this;
    }

    @Override
    public ParserGroupBuilder bpro(Map<String, String> values) {
        super.bpro(values);
        return this;
    }

    @Override
    public ParserGroupBuilder bpro(String beanClassName, String value) {
        super.bpro(beanClassName, value);
        return this;
    }

    @Override
    public ParserGroupBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo(beanClass, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpwo(Map<String, String> values) {
        super.bpwo(values);
        return this;
    }

    @Override
    public ParserGroupBuilder bpwo(String beanClassName, String value) {
        super.bpwo(beanClassName, value);
        return this;
    }

    @Override
    public ParserGroupBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public ParserGroupBuilder dictionary(Class<?> ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public ParserGroupBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public ParserGroupBuilder dictionaryReplace(Class<?> ... values) {
        super.dictionaryReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder dictionaryReplace(Object ... values) {
        super.dictionaryReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder dictionaryRemove(Class<?> ... values) {
        super.dictionaryRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder dictionaryRemove(Object ... values) {
        super.dictionaryRemove(values);
        return this;
    }

    @Override
    public <T> ParserGroupBuilder example(Class<T> c, T o) {
        super.example(c, o);
        return this;
    }

    @Override
    public <T> ParserGroupBuilder exampleJson(Class<T> c, String value) {
        super.exampleJson(c, value);
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        super.ignoreInvocationExceptionsOnGetters(value);
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        super.ignoreInvocationExceptionsOnSetters(value);
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    @Override
    public ParserGroupBuilder ignorePropertiesWithoutSetters(boolean value) {
        super.ignorePropertiesWithoutSetters(value);
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreUnknownBeanProperties(boolean value) {
        super.ignoreUnknownBeanProperties(value);
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreUnknownNullBeanProperties(boolean value) {
        super.ignoreUnknownNullBeanProperties(value);
        return this;
    }

    @Override
    public ParserGroupBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    @Override
    public ParserGroupBuilder implClasses(Map<String, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    @Override
    public ParserGroupBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public ParserGroupBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanClasses(Class<?> ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanClassesReplace(Class<?> ... values) {
        super.notBeanClassesReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanClassesReplace(Object ... values) {
        super.notBeanClassesReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanClassesRemove(Class<?> ... values) {
        super.notBeanClassesRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanClassesRemove(Object ... values) {
        super.notBeanClassesRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanPackages(String ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanPackagesReplace(String ... values) {
        super.notBeanPackagesReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanPackagesReplace(Object ... values) {
        super.notBeanPackagesReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanPackagesRemove(String ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanPackagesRemove(Object ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder pojoSwaps(Class<?> ... values) {
        super.pojoSwaps(values);
        return this;
    }

    @Override
    public ParserGroupBuilder pojoSwaps(Object ... values) {
        super.pojoSwaps(values);
        return this;
    }

    @Override
    public ParserGroupBuilder pojoSwapsReplace(Class<?> ... values) {
        super.pojoSwapsReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder pojoSwapsReplace(Object ... values) {
        super.pojoSwapsReplace(values);
        return this;
    }

    @Override
    public ParserGroupBuilder pojoSwapsRemove(Class<?> ... values) {
        super.pojoSwapsRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder pojoSwapsRemove(Object ... values) {
        super.pojoSwapsRemove(values);
        return this;
    }

    @Override
    public ParserGroupBuilder sortProperties(boolean value) {
        super.sortProperties(value);
        return this;
    }

    @Override
    public ParserGroupBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    @Override
    public ParserGroupBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    @Override
    public ParserGroupBuilder useEnumNames(boolean value) {
        super.useEnumNames(value);
        return this;
    }

    @Override
    public ParserGroupBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    @Override
    public ParserGroupBuilder useInterfaceProxies(boolean value) {
        super.useInterfaceProxies(value);
        return this;
    }

    @Override
    public ParserGroupBuilder useJavaBeanIntrospector(boolean value) {
        super.useJavaBeanIntrospector(value);
        return this;
    }

    @Override
    public ParserGroupBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    @Override
    public ParserGroupBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        return this;
    }

    @Override
    public ParserGroupBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public ParserGroupBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder addTo(String name, String key, Object value) {
        super.addTo(name, key, value);
        return this;
    }

    @Override
    public ParserGroupBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public ParserGroupBuilder applyAnnotations(AnnotationList al, VarResolverSession vrs) {
        super.applyAnnotations(al, vrs);
        return this;
    }

    @Override
    public ParserGroupBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    @Override
    public ParserGroupBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }
}

