/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.pojotools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.pojotools.PojoTool;
import org.apache.juneau.pojotools.SortArgs;

public final class PojoSorter
implements PojoTool<SortArgs> {
    @Override
    public Object run(BeanSession session, Object input, SortArgs args) {
        if (input == null) {
            return null;
        }
        Map<String, Boolean> sort = args.getSort();
        if (sort.isEmpty()) {
            return input;
        }
        ClassMeta<Object> type = session.getClassMetaForObject(input);
        if (!type.isCollectionOrArray()) {
            return input;
        }
        ArrayList<SortEntry> l = null;
        if (type.isArray()) {
            int size = Array.getLength(input);
            l = new ArrayList<SortEntry>(size);
            for (int i = 0; i < size; ++i) {
                l.add(new SortEntry(session, Array.get(input, i)));
            }
        } else {
            Collection c = (Collection)input;
            l = new ArrayList(c.size());
            for (Object o : c) {
                l.add(new SortEntry(session, o));
            }
        }
        ArrayList<String> columns = new ArrayList<String>(sort.keySet());
        Collections.reverse(columns);
        for (String c : columns) {
            boolean isDesc = sort.get(c);
            for (SortEntry se : l) {
                se.setSort(c, isDesc);
            }
            Collections.sort(l);
        }
        ArrayList<Object> l2 = new ArrayList<Object>(l.size());
        for (SortEntry se : l) {
            l2.add(se.o);
        }
        return l2;
    }

    private static class SortEntry
    implements Comparable {
        Object o;
        ClassMeta<?> cm;
        BeanSession bs;
        Object sortVal;
        boolean isDesc;

        SortEntry(BeanSession bs, Object o) {
            this.o = o;
            this.bs = bs;
            this.cm = bs.getClassMetaForObject(o);
        }

        void setSort(String sortCol, boolean isDesc) {
            this.isDesc = isDesc;
            this.sortVal = this.cm == null ? null : (this.cm.isMap() ? ((Map)this.o).get(sortCol) : (this.cm.isBean() ? this.bs.toBeanMap(this.o).get(sortCol) : null));
        }

        public int compareTo(Object o) {
            if (this.isDesc) {
                return ObjectUtils.compare(((SortEntry)o).sortVal, this.sortVal);
            }
            return ObjectUtils.compare(this.sortVal, ((SortEntry)o).sortVal);
        }
    }
}

