/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonWriter;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.transform.PojoSwap;

public class JsonSerializerSession
extends WriterSerializerSession {
    private final JsonSerializer ctx;

    protected JsonSerializerSession(JsonSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        this.serializeAnything(this.getJsonWriter(out), o, this.getExpectedRootType(o), "root", null);
    }

    protected String serializeJson(Object o) throws Exception {
        StringWriter sw = new StringWriter();
        this.serializeAnything(this.getJsonWriter(this.createPipe(sw)), o, this.getExpectedRootType(o), "root", null);
        return sw.toString();
    }

    protected JsonWriter serializeAnything(JsonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws IOException, SerializeException {
        String wrapperAttr;
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            out.append("null");
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = this.push2(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (this.isOptional(aType)) {
            o = this.getOptionalValue(o);
            eType = this.getOptionalType(eType);
            aType = this.getClassMetaForObject(o, this.object());
        }
        ClassMeta<Object> sType = aType;
        String typeName = this.getBeanTypeName(eType, aType, pMeta);
        PojoSwap<Object, ?> swap = aType.getPojoSwap(this);
        if (swap != null) {
            o = this.swap(swap, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if ((wrapperAttr = this.getJsonClassMeta(sType).getWrapperAttr()) != null) {
            out.append('{').cr(this.indent).attr(wrapperAttr).append(':').s(this.indent);
            ++this.indent;
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.append("null");
        } else if (sType.isNumber() || sType.isBoolean()) {
            out.append(o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.uriValue(o);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(out, JsonSerializerSession.toList(sType.getInnerClass(), o), eType);
        } else if (sType.isReader() || sType.isInputStream()) {
            IOUtils.pipe(o, out);
        } else {
            out.stringValue(this.toString(o));
        }
        if (wrapperAttr != null) {
            --this.indent;
            out.cre(this.indent - 1).append('}');
        }
        if (!isRecursion) {
            this.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(JsonWriter out, Map m, ClassMeta<?> type) throws IOException, SerializeException {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        m = this.sort(m);
        int i = this.indent;
        out.append('{');
        Iterator mapEntries = m.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry e = mapEntries.next();
            Object value = e.getValue();
            Object key = this.generalize(e.getKey(), keyType);
            out.cr(i).attr(this.toString(key)).append(':').s(i);
            this.serializeAnything(out, value, valueType, key == null ? null : this.toString(key), null);
            if (!mapEntries.hasNext()) continue;
            out.append(',').smi(i);
        }
        out.cre(i - 1).append('}');
        return out;
    }

    private SerializerWriter serializeBeanMap(JsonWriter out, BeanMap<?> m, String typeName) throws IOException, SerializeException {
        int i = this.indent;
        out.append('{');
        boolean addComma = false;
        for (BeanPropertyValue p : m.getValues(this.isTrimNullProperties(), typeName != null ? JsonSerializerSession.createBeanTypeNameProperty(m, typeName) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            if (!pMeta.canRead()) continue;
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            if (addComma) {
                out.append(',').smi(i);
            }
            out.cr(i).attr(key).append(':').s(i);
            this.serializeAnything(out, value, cMeta, key, pMeta);
            addComma = true;
        }
        out.cre(i - 1).append('}');
        return out;
    }

    private SerializerWriter serializeCollection(JsonWriter out, Collection c, ClassMeta<?> type) throws IOException, SerializeException {
        ClassMeta<?> elementType = type.getElementType();
        c = this.sort(c);
        out.append('[');
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            out.cr(this.indent);
            this.serializeAnything(out, value, elementType, "<iterator>", null);
            if (!i.hasNext()) continue;
            out.append(',').smi(this.indent);
        }
        out.cre(this.indent - 1).append(']');
        return out;
    }

    protected final JsonWriter getJsonWriter(SerializerPipe out) throws IOException {
        Object output = out.getRawOutput();
        if (output instanceof JsonWriter) {
            return (JsonWriter)output;
        }
        JsonWriter w = new JsonWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isEscapeSolidus(), this.getQuoteChar(), this.isSimpleMode(), this.isTrimStrings(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isEscapeSolidus() {
        return this.ctx.isEscapeSolidus();
    }

    protected final boolean isSimpleMode() {
        return this.ctx.isSimpleMode();
    }

    protected JsonClassMeta getJsonClassMeta(ClassMeta<?> cm) {
        return this.ctx.getJsonClassMeta(cm);
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("JsonSerializerSession", new DefaultFilteringObjectMap());
    }
}

