/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converters;

import org.apache.juneau.BeanSession;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.PojoIntrospector;

public final class Introspectable
implements RestConverter {
    public static final String SWAGGER_PARAMS = "{in:'query',name:'invokeMethod',description:' The Java method name, optionally with arguments if necessary to differentiate between methods.',x-examples:{example:'toString'}},{in:'query',name:'invokeArgs',description:'The arguments as an array.',x-examples:{example:'foo,bar'}}";

    @Override
    public Object convert(RestRequest req, Object o) throws InternalServerError {
        String method = req.getQuery().getString("invokeMethod");
        String args = req.getQuery().getString("invokeArgs");
        if (method == null) {
            return o;
        }
        try {
            BeanSession bs = req.getBeanSession();
            PojoSwap swap = bs.getClassMetaForObject(o).getPojoSwap(bs);
            if (swap != null) {
                o = swap.swap(bs, o);
            }
            return new PojoIntrospector(o, (ReaderParser)JsonParser.DEFAULT).invokeMethod(method, args);
        }
        catch (Exception e) {
            return new InternalServerError((Throwable)e, "Error occurred trying to invoke method: {0}", new Object[]{e.getLocalizedMessage()});
        }
    }
}

