/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.ASet;

@Bean(bpi="description,schema,headers,x-example,examples,*")
public class ResponseInfo
extends SwaggerElement {
    private String description;
    private SchemaInfo schema;
    private Map<String, HeaderInfo> headers;
    private Object example;
    private Map<String, Object> examples;

    public ResponseInfo() {
    }

    public ResponseInfo(ResponseInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        SchemaInfo schemaInfo = this.schema = copyFrom.schema == null ? null : copyFrom.schema.copy();
        if (copyFrom.headers == null) {
            this.headers = null;
        } else {
            this.headers = new LinkedHashMap<String, HeaderInfo>();
            for (Map.Entry<String, HeaderInfo> e : copyFrom.headers.entrySet()) {
                this.headers.put(e.getKey(), e.getValue().copy());
            }
        }
        this.example = copyFrom.example;
        this.examples = copyFrom.examples == null ? null : new LinkedHashMap<String, Object>(copyFrom.examples);
    }

    public ResponseInfo copy() {
        return new ResponseInfo(this);
    }

    public ResponseInfo copyFrom(ResponseInfo r) {
        if (r != null) {
            if (r.description != null) {
                this.description = r.description;
            }
            if (r.schema != null) {
                this.schema = r.schema;
            }
            if (r.headers != null) {
                this.headers = r.headers;
            }
            if (r.example != null) {
                this.example = r.example;
            }
            if (r.examples != null) {
                this.examples = r.examples;
            }
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ResponseInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public ResponseInfo description(Object value) {
        return this.setDescription(StringUtils.stringify(value));
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public ResponseInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    public ResponseInfo schema(Object value) {
        return this.setSchema(ObjectUtils.toType(value, SchemaInfo.class));
    }

    public Map<String, HeaderInfo> getHeaders() {
        return this.headers;
    }

    public ResponseInfo setHeaders(Map<String, HeaderInfo> value) {
        this.headers = CollectionUtils.newMap(value);
        return this;
    }

    public ResponseInfo addHeaders(Map<String, HeaderInfo> values) {
        this.headers = CollectionUtils.addToMap(this.headers, values);
        return this;
    }

    public ResponseInfo header(String name, HeaderInfo header) {
        this.addHeaders(Collections.singletonMap(name, header));
        return this;
    }

    public ResponseInfo headers(Object ... values) {
        this.headers = CollectionUtils.addToMap(this.headers, values, String.class, HeaderInfo.class, new Type[0]);
        return this;
    }

    public HeaderInfo getHeader(String name) {
        return this.getHeaders().get(name);
    }

    @Beanp(value="x-example")
    public Object getExample() {
        return this.example;
    }

    @Beanp(value="x-example")
    public ResponseInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public ResponseInfo example(Object value) {
        this.example = value;
        return this;
    }

    public Map<String, Object> getExamples() {
        return this.examples;
    }

    public ResponseInfo setExamples(Map<String, Object> value) {
        this.examples = CollectionUtils.newMap(value);
        return this;
    }

    public ResponseInfo addExamples(Map<String, Object> values) {
        this.examples = CollectionUtils.addToMap(this.examples, values);
        return this;
    }

    public ResponseInfo example(String mimeType, Object example) {
        this.examples = CollectionUtils.addToMap(this.examples, mimeType, example);
        return this;
    }

    public ResponseInfo examples(Object ... values) {
        this.examples = CollectionUtils.addToMap(this.examples, values, String.class, Object.class, new Type[0]);
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "description": {
                return ObjectUtils.toType(this.getDescription(), type);
            }
            case "schema": {
                return ObjectUtils.toType(this.getSchema(), type);
            }
            case "headers": {
                return ObjectUtils.toType(this.getHeaders(), type);
            }
            case "example": {
                return ObjectUtils.toType(this.getExample(), type);
            }
            case "examples": {
                return ObjectUtils.toType(this.getExamples(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public ResponseInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "description": {
                return this.description(value);
            }
            case "schema": {
                return this.schema(value);
            }
            case "headers": {
                return this.setHeaders(null).headers(value);
            }
            case "example": {
                return this.setExample(value);
            }
            case "examples": {
                return this.setExamples(null).examples(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet<String> s = new ASet<String>().appendIf(this.description != null, "description").appendIf(this.schema != null, "schema").appendIf(this.headers != null, "headers").appendIf(this.example != null, "example").appendIf(this.examples != null, "examples");
        return new MultiSet<String>(s, super.keySet());
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public ResponseInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.schema != null) {
            this.schema = this.schema.resolveRefs(swagger, refStack, maxDepth);
        }
        if (this.headers != null) {
            for (Map.Entry<String, HeaderInfo> e : this.headers.entrySet()) {
                e.setValue(e.getValue().resolveRefs(swagger, refStack, maxDepth));
            }
        }
        return this;
    }
}

