/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.Scale;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import com.github.weisj.darklaf.util.graphics.ScaledImage;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static ScaledImage imageFromComponent(Component c) {
        return ImageUtil.scaledImageFromComponent(c, new Rectangle(0, 0, c.getWidth(), c.getHeight()), 1.0, 1.0, true);
    }

    public static ScaledImage imageFromComponent(Component c, Rectangle bounds) {
        return ImageUtil.scaledImageFromComponent(c, bounds, 1.0, 1.0, true);
    }

    public static ScaledImage imageFromComponent(Component c, Rectangle bounds, boolean print) {
        return ImageUtil.scaledImageFromComponent(c, bounds, 1.0, 1.0, print);
    }

    public static ScaledImage scaledImageFromComponent(Component c) {
        return ImageUtil.scaledImageFromComponent(c, new Rectangle(0, 0, c.getWidth(), c.getHeight()), false);
    }

    public static ScaledImage scaledImageFromComponent(Component c, Rectangle bounds) {
        return ImageUtil.scaledImageFromComponent(c, bounds, false);
    }

    public static ScaledImage scaledImageFromComponent(Component c, Rectangle bounds, boolean print) {
        GraphicsConfiguration gc = c.getGraphicsConfiguration();
        return ImageUtil.scaledImageFromComponent(c, bounds, Scale.getScaleX(gc), Scale.getScaleY(gc), print);
    }

    public static ScaledImage scaledImageFromComponent(Component c, Rectangle bounds, double scalex, double scaley, boolean print) {
        boolean scale = scalex != 1.0 || scaley != 1.0;
        BufferedImage image = scale ? ImageUtil.createCompatibleTransparentImage(c.getGraphicsConfiguration(), (int)(scalex * (double)bounds.width), (int)(scaley * (double)bounds.height)) : ImageUtil.createCompatibleTransparentImage(c.getGraphicsConfiguration(), bounds.width, bounds.height);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        GraphicsUtil.setupAntialiasing(g2d);
        if (scale) {
            g2d.scale(scalex, scaley);
        }
        g2d.translate(-bounds.x, -bounds.y);
        if (print) {
            c.print(g2d);
        } else {
            c.paint(g2d);
        }
        g2d.dispose();
        return new ScaledImage(image, scalex, scaley);
    }

    public static BufferedImage createCompatibleImage(GraphicsConfiguration gc, int width, int height) {
        return gc == null ? new BufferedImage(width, height, 1) : gc.createCompatibleImage(width, height, 1);
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return ImageUtil.createCompatibleImage(ImageUtil.getGraphicsConfiguration(), width, height);
    }

    public static BufferedImage createCompatibleTransparentImage(GraphicsConfiguration gc, int width, int height) {
        return gc == null ? new BufferedImage(width, height, 2) : gc.createCompatibleImage(width, height, 2);
    }

    public static BufferedImage createCompatibleTransparentImage(int width, int height) {
        return ImageUtil.createCompatibleTransparentImage(ImageUtil.getGraphicsConfiguration(), width, height);
    }

    public static BufferedImage createCompatibleTranslucentImage(GraphicsConfiguration gc, int width, int height) {
        return gc == null ? new BufferedImage(width, height, 2) : gc.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return ImageUtil.createCompatibleTranslucentImage(ImageUtil.getGraphicsConfiguration(), width, height);
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return ImageUtil.isHeadless() ? null : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }
}

