/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.hierarchy;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hierarchy.IHasChildren;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IHasChildrenSorted<CHILDTYPE>
extends IHasChildren<CHILDTYPE> {
    @Override
    @Nullable
    public ICommonsList<? extends CHILDTYPE> getAllChildren();

    @Nullable
    public CHILDTYPE getChildAtIndex(@Nonnegative int var1);

    @Nullable
    default public CHILDTYPE getFirstChild() {
        return this.getChildAtIndex(0);
    }

    @Nullable
    default public CHILDTYPE findFirstChild(@Nonnull Predicate<? super CHILDTYPE> predicate) {
        if (this.hasNoChildren()) {
            return null;
        }
        return this.getChildren().findFirst(predicate);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstChildMapped(@Nonnull Predicate<? super CHILDTYPE> predicate, @Nonnull Function<? super CHILDTYPE, ? extends DSTTYPE> function) {
        if (this.hasNoChildren()) {
            return null;
        }
        return this.getChildren().findFirstMapped(predicate, function);
    }

    @Nullable
    default public CHILDTYPE getLastChild() {
        return this.getChildAtIndex(this.getChildCount() - 1);
    }
}

