/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JTable;

public final class DividedWidgetPainter {
    public static void paintBackground(Graphics2D g, JComponent c, int arc, Rectangle splitBounds, Color bg, Color splitBg, boolean isCellEditor) {
        int w = c.getWidth();
        int h = c.getHeight();
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        Insets ins = c.getInsets();
        g.setColor(bg);
        DividedWidgetPainter.fillBackground(g, w, h, arc, ins, isCellEditor);
        if (splitBounds != null) {
            Shape oldClip = g.getClip();
            if (ltr) {
                g.clipRect(splitBounds.x, 0, w - splitBounds.x, h);
            } else {
                g.clipRect(0, 0, splitBounds.x + splitBounds.width, h);
            }
            g.setColor(splitBg);
            DividedWidgetPainter.fillBackground(g, w, h, arc, ins, isCellEditor);
            g.setClip(oldClip);
        }
    }

    private static void fillBackground(Graphics2D g, int w, int h, int arc, Insets ins, boolean isCellEditor) {
        if (!isCellEditor) {
            PaintUtil.fillRoundRect(g, w, h, ins, arc);
        } else {
            g.fillRect(ins.left, ins.top, w - ins.right - ins.left, h - ins.top - ins.bottom);
        }
    }

    public static void paintBorder(Graphics2D g, JComponent c, int width, int height, int arc, int borderSize, int dividerLocation, boolean isTableEditor, boolean isTreeEditor, boolean hasFocus, Color borderColor, Color focusBorderColor) {
        boolean isCellEditor = isTableEditor || isTreeEditor;
        Insets ins = c.getInsets();
        g.setColor(borderColor);
        if (dividerLocation >= 0) {
            g.fillRect(dividerLocation, ins.top, 1, height - ins.top - ins.bottom);
        }
        if (!isCellEditor) {
            if (hasFocus) {
                PaintUtil.paintFocusBorder(g, width, height, arc, borderSize);
                g.setColor(focusBorderColor);
            }
            PaintUtil.paintLineBorder(g, width, height, ins, arc);
        } else {
            DividedWidgetPainter.paintCellBorder(g, c, width, height, ins, isTableEditor);
        }
    }

    private static void paintCellBorder(Graphics2D g, Component c, int width, int height, Insets ins, boolean isTableCellEditor) {
        Container parent = c.getParent();
        if (isTableCellEditor && parent instanceof JTable) {
            JTable table = (JTable)parent;
            CellUtil.paintTableEditorBorder(g, c, table, width, height);
        } else {
            PaintUtil.drawRect((Graphics)g, ins.left, ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom, 1);
        }
    }
}

