/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIs;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class LangJSONLD11
implements ReaderRIOT {
    private final ErrorHandler errorHandler;
    private final ParserProfile profile;
    private static final String SYMBOLS_NS = "http://jena.apache.org/riot/jsonld#";
    public static final Symbol JSONLD_OPTIONS = SystemARQ.allocSymbol("http://jena.apache.org/riot/jsonld#", "options");

    public LangJSONLD11(Lang language, ParserProfile profile, ErrorHandler errorHandler) {
        this.profile = profile;
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(InputStream input, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            JsonDocument document = JsonDocument.of(input);
            this.read(document, baseURI, output, context2);
        }
        catch (JsonLdError ex) {
            this.handleJsonLdError(ex);
        }
        catch (Exception ex) {
            this.errorHandler.error(ex.getMessage(), -1L, -1L);
            throw new RiotException(ex);
        }
    }

    private void handleJsonLdError(JsonLdError ex) {
        JsonLdError ex2;
        Throwable cause = ex.getCause();
        if (cause instanceof JsonParsingException) {
            JsonParsingException exp = (JsonParsingException)cause;
            JsonLocation loc = exp.getLocation();
            this.errorHandler.error(ex.getMessage(), loc.getLineNumber(), loc.getColumnNumber());
        } else if (cause instanceof JsonLdError && ex != (ex2 = (JsonLdError)cause)) {
            this.errorHandler.error(ex2.getMessage(), -1L, -1L);
        }
        throw new RiotException(ex);
    }

    @Override
    public void read(Reader in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            JsonDocument document = JsonDocument.of(in);
            this.read(document, baseURI, output, context2);
        }
        catch (JsonLdError ex) {
            this.handleJsonLdError(ex);
        }
        catch (Exception ex) {
            this.errorHandler.error(ex.getMessage(), -1L, -1L);
            throw new RiotException(ex);
        }
    }

    private void read(Document document, String baseURI, StreamRDF output, Context context2) throws JsonLdError {
        JsonLdOptions opts = LangJSONLD11.getJsonLdOptions(baseURI, context2);
        LangJSONLD11.extractPrefixes(document, output::prefix);
        JsonLDToStreamRDF consumer = new JsonLDToStreamRDF(output, this.profile);
        JsonLd.toRdf(document).options(opts).provide(consumer);
    }

    private static void extractPrefixes(Document document, BiConsumer<String, String> action) {
        try {
            JsonStructure jsonStructure = document.getJsonContent().orElse(null);
            if (jsonStructure == null) {
                return;
            }
            LangJSONLD11.extractPrefixesValue(jsonStructure, action);
        }
        catch (Throwable ex) {
            Log.warn(LangJSONLD11.class, "Unexpected problem while extracting prefixes: " + ex.getMessage(), ex);
        }
    }

    private static void extractPrefixesValue(JsonValue jsonValue, BiConsumer<String, String> action) {
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                LangJSONLD11.extractPrefixesArray(jsonValue.asJsonArray(), action);
                break;
            }
            case OBJECT: {
                LangJSONLD11.extractPrefixesObject(jsonValue.asJsonObject(), action);
                break;
            }
        }
    }

    private static void extractPrefixesArray(JsonArray jsonArray, BiConsumer<String, String> action) {
        jsonArray.forEach(jv -> LangJSONLD11.extractPrefixesValue(jv, action));
    }

    private static void extractPrefixesObject(JsonObject jsonObject, BiConsumer<String, String> action) {
        JsonValue contextValue = (JsonValue)jsonObject.get("@context");
        if (contextValue == null) {
            return;
        }
        switch (contextValue.getValueType()) {
            case ARRAY: {
                LangJSONLD11.extractPrefixesContextArray(contextValue.asJsonArray(), action);
                break;
            }
            case OBJECT: {
                LangJSONLD11.extractPrefixesContextDefinition(contextValue.asJsonObject(), action);
                break;
            }
        }
    }

    private static void extractPrefixesContextArray(JsonArray jsonArray, BiConsumer<String, String> action) {
        jsonArray.forEach(cxtArrayEntry -> {
            switch (cxtArrayEntry.getValueType()) {
                case OBJECT: {
                    LangJSONLD11.extractPrefixesContextDefinition(cxtArrayEntry.asJsonObject(), action);
                    break;
                }
            }
        });
    }

    private static void extractPrefixesContextDefinition(JsonObject jCxt, BiConsumer<String, String> action) {
        Set keys = jCxt.keySet();
        keys.stream().forEach(k -> {
            JsonValue jValue = (JsonValue)jCxt.get(k);
            if (JsonValue.ValueType.STRING != jValue.getValueType()) {
                return;
            }
            String prefix = k;
            if ("@vocab".equals(k)) {
                prefix = "";
            } else if (k.startsWith("@")) {
                return;
            }
            String uri = ((JsonString)JsonString.class.cast(jValue)).getString();
            if (uri.endsWith("#") || uri.endsWith("/") || uri.endsWith(":")) {
                if (IRIs.check(uri)) {
                    action.accept(prefix, uri);
                }
                return;
            }
        });
    }

    private static JsonLdOptions getJsonLdOptions(String baseURI, Context jenaContext) {
        JsonLdOptions opts = (JsonLdOptions)jenaContext.get(JSONLD_OPTIONS);
        if (opts == null) {
            opts = new JsonLdOptions();
        }
        if (baseURI != null) {
            opts.setBase(URI.create(baseURI));
        }
        return opts;
    }

    static class JsonLDToStreamRDF
    implements RdfQuadConsumer {
        private static long line = -1L;
        private static long col = -1L;
        private final StreamRDF output;
        private final ParserProfile profile;

        JsonLDToStreamRDF(StreamRDF output, ParserProfile profile) {
            this.output = output;
            this.profile = profile;
        }

        @Override
        public RdfQuadConsumer quad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) throws RdfConsumerException {
            Node g = graph == null ? null : this.convertToNode(graph);
            Node s = this.convertToNode(subject);
            Node p = this.convertToNode(predicate);
            Node o = RdfQuadConsumer.isLiteral(datatype, language, direction) ? this.convertToLiteral(object, datatype, language, direction) : this.convertToNode(object);
            if (g == null) {
                this.output.triple(Triple.create(s, p, o));
            } else {
                this.output.quad(Quad.create(g, s, p, o));
            }
            return this;
        }

        private Node convertToNode(String str2) {
            if (RdfQuadConsumer.isBlank(str2)) {
                str2 = str2.substring(2);
                Node bn = this.profile.getFactorRDF().createBlankNode(str2);
                return bn;
            }
            str2 = this.profile.resolveIRI(str2, line, col);
            Node iri2 = this.profile.createURI(str2, line, col);
            return iri2;
        }

        private Node convertToLiteral(String lexical, String datatypeURI, String language, String direction) {
            if (RdfQuadConsumer.isLangString(datatypeURI, language, direction)) {
                return this.profile.createLangLiteral(lexical, language, line, col);
            }
            if (RdfQuadConsumer.isDirLangString(datatypeURI, language, direction)) {
                return this.profile.createLangDirLiteral(lexical, language, direction, line, col);
            }
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            return this.profile.createTypedLiteral(lexical, dType, line, col);
        }
    }
}

