/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.DataRange;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.QualifiedRestriction;
import org.apache.jena.ontology.impl.RestrictionImpl;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;

public class QualifiedRestrictionImpl
extends RestrictionImpl
implements QualifiedRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new QualifiedRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + String.valueOf(n) + " to QualifiedRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return QualifiedRestrictionImpl.isValidQualifiedRestriction(node, eg);
        }
    };

    private static boolean isValidQualifiedRestriction(Node node, EnhGraph eg) {
        Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
        return profile != null && profile.isSupported(node, eg, QualifiedRestriction.class);
    }

    @Override
    public boolean isValid() {
        return QualifiedRestrictionImpl.isValidQualifiedRestriction(this.asNode(), this.getGraph());
    }

    public QualifiedRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setHasClassQ(OntClass cls) {
        this.setPropertyValue(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q", cls);
    }

    @Override
    public OntResource getHasClassQ() {
        this.checkProfile(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        Resource r = this.getProperty(this.getProfile().HAS_CLASS_Q()).getResource();
        if (r.canAs(OntClass.class)) {
            return r.as(OntClass.class);
        }
        if (r.canAs(DataRange.class)) {
            return r.as(DataRange.class);
        }
        return r.as(OntResource.class);
    }

    @Override
    public boolean hasHasClassQ(OntClass cls) {
        return this.hasPropertyValue(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q", cls);
    }

    @Override
    public boolean hasHasClassQ(DataRange dr) {
        return this.hasPropertyValue(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q", dr);
    }

    @Override
    public void removeHasClassQ(OntClass cls) {
        Property has_class_q = this.getProfile().HAS_CLASS_Q();
        this.removePropertyValue(has_class_q, "HAS_CLASS_Q", cls);
    }

    @Override
    public void removeHasClassQ(DataRange dr) {
        this.removePropertyValue(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q", dr);
    }
}

