/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.langtag;

import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.langtag.LangTag;

public final class LangTagJDK
implements LangTag {
    private final String langTagAsGiven;
    private final String fmtString;
    private final String lang;
    private final String script;
    private final String region;
    private final String variant;
    private final String extension;
    private final String privateUse;
    private static Locale.Builder locBuild = new Locale.Builder();
    private static Character privateUseSingleton = Character.valueOf('x');

    public static LangTag create(String string) {
        try {
            locBuild.clear();
            locBuild.setLanguageTag(string);
            return LangTagJDK.asLangTag(string, locBuild);
        }
        catch (IllformedLocaleException ex) {
            return null;
        }
    }

    private LangTagJDK(String langTagAsGiven, String fmtString, String language, String script, String region, String variant, String extension, String privateUse) {
        this.langTagAsGiven = langTagAsGiven;
        this.fmtString = Objects.requireNonNull(fmtString);
        this.lang = LangTagJDK.maybe(language);
        this.script = LangTagJDK.maybe(script);
        this.region = LangTagJDK.maybe(region);
        this.variant = LangTagJDK.maybe(variant);
        this.extension = LangTagJDK.maybe(extension);
        this.privateUse = LangTagJDK.maybe(privateUse);
    }

    private static String maybe(String x) {
        if (x == null) {
            return null;
        }
        if (x.isEmpty()) {
            return null;
        }
        return x;
    }

    @Override
    public String str() {
        return this.fmtString;
    }

    @Override
    public String getLanguage() {
        return this.lang;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getPrivateUse() {
        return this.privateUse;
    }

    public static String canonical(String str2) {
        try {
            return locBuild.setLanguageTag(str2).build().toLanguageTag();
        }
        catch (IllformedLocaleException ex) {
            return str2;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.langTagAsGiven, this.fmtString, this.lang, this.script, this.region, this.variant, this.extension, this.privateUse);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LangTagJDK)) {
            return false;
        }
        LangTagJDK other = (LangTagJDK)obj;
        return Objects.equals(this.lang, other.lang) && Objects.equals(this.script, other.script) && Objects.equals(this.region, other.region) && Objects.equals(this.variant, other.variant) && Objects.equals(this.extension, other.extension) && Objects.equals(this.privateUse, other.privateUse) && Objects.equals(this.langTagAsGiven, other.langTagAsGiven) && Objects.equals(this.fmtString, other.fmtString);
    }

    private static LangTag asLangTag(String string, Locale.Builder locBuild) {
        Locale locale = locBuild.build();
        Set<Character> extkeys = locale.getExtensionKeys();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (Character k : extkeys) {
            String ext = locale.getExtension(k.charValue());
            StringBuilder sb = sb1;
            if (privateUseSingleton.equals(k)) {
                sb = sb2;
            }
            if (sb.length() != 0) {
                sb.append('-');
            }
            sb.append(k);
            sb.append('-');
            sb.append(ext);
        }
        String extension = sb1.toString();
        String privateUse = sb2.toString();
        return new LangTagJDK(string, locale.toLanguageTag(), locale.getLanguage(), locale.getScript(), locale.getCountry(), locale.getVariant(), extension, privateUse);
    }
}

