/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import org.apache.jena.atlas.io.IO;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;

public class ModItem
extends ModBase {
    protected final ArgDecl queryFileDecl = new ArgDecl(true, "file");
    private String filename = null;
    private String parseString = null;
    private Item item = null;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Item");
        cmdLine.add(this.queryFileDecl, "--file=", "File");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.queryFileDecl)) {
            this.filename = cmdLine.getValue(this.queryFileDecl);
            this.parseString = IO.readWholeFileAsUTF8(this.filename);
            return;
        }
        if (cmdLine.getNumPositional() == 0 && this.filename == null) {
            cmdLine.cmdError("No query string or query file");
        }
        if (cmdLine.getNumPositional() > 1) {
            cmdLine.cmdError("Only one query string allowed");
        }
        if (cmdLine.getNumPositional() == 1 && this.filename != null) {
            cmdLine.cmdError("Either query string or query file - not both");
        }
        if (this.filename == null) {
            String qs = cmdLine.getPositionalArg(0);
            this.parseString = cmdLine.indirect(qs);
        }
    }

    public Item getItem() {
        if (this.item != null) {
            return this.item;
        }
        this.item = SSE.parseItem(this.parseString);
        return this.item;
    }
}

