/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.base.file;

import org.apache.jena.tdb1.base.file.BufferChannel;
import org.apache.jena.tdb1.base.file.BufferChannelFile;
import org.apache.jena.tdb1.base.file.BufferChannelMem;
import org.apache.jena.tdb1.base.file.PlainFile;
import org.apache.jena.tdb1.base.file.PlainFileMem;
import org.apache.jena.tdb1.base.file.PlainFilePersistent;
import org.apache.jena.tdb1.base.objectfile.ObjectFile;
import org.apache.jena.tdb1.base.objectfile.ObjectFileStorage;
import org.apache.jena.tdb1.base.objectfile.StringFile;

public class FileFactory {
    public static StringFile createStringFileDisk(String filename) {
        return new StringFile(FileFactory.createObjectFileDisk(filename));
    }

    public static StringFile createStringFileMem(String filename) {
        return new StringFile(FileFactory.createObjectFileMem(filename));
    }

    public static ObjectFile createObjectFileDisk(String filename) {
        BufferChannelFile file = BufferChannelFile.create(filename);
        return new ObjectFileStorage(file);
    }

    public static ObjectFile createObjectFileMem(String filename) {
        BufferChannel file = BufferChannelMem.create(filename);
        return new ObjectFileStorage(file);
    }

    public static PlainFile createPlainFileDisk(String filename) {
        return new PlainFilePersistent(filename);
    }

    public static PlainFile createPlainFileMem() {
        return new PlainFileMem();
    }
}

