/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.nquads;

import java.util.function.IntPredicate;

public final class NQuadsAlphabet {
    public static final String I18N_BASE = "https://www.w3.org/ns/i18n#";
    public static final String LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    public static final String DIR_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#dirLangString";
    public static final String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";
    public static final IntPredicate ASCII_ALPHA = ch -> 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90;
    public static final IntPredicate ASCII_DIGIT = ch -> 48 <= ch && ch <= 57;
    public static final IntPredicate ASCII_ALPHA_NUM = ASCII_DIGIT.or(ASCII_ALPHA);
    public static final IntPredicate WHITESPACE = ch -> ch == 9 || ch == 32;
    public static final IntPredicate EOL = ch -> ch == 10 || ch == 13;
    public static final IntPredicate HEX = ASCII_DIGIT.or(ch -> 97 <= ch && ch <= 102 || 65 <= ch && ch <= 70);
    public static final IntPredicate PN_CHARS_BASE = ASCII_ALPHA.or(ch -> 192 <= ch && ch <= 214 || 216 <= ch && ch <= 246 || 248 <= ch && ch <= 767 || 880 <= ch && ch <= 893 || 895 <= ch && ch <= 8191 || 8204 <= ch && ch <= 8205 || 8304 <= ch && ch <= 8591 || 11264 <= ch && ch <= 12271 || 12289 <= ch && ch <= 55295 || 63744 <= ch && ch <= 64975 || 65008 <= ch && ch <= 65533 || 65536 <= ch && ch <= 983039);
    public static final IntPredicate PN_CHARS_U = PN_CHARS_BASE.or(ch -> 95 == ch || 58 == ch);
    public static final IntPredicate PN_CHARS = PN_CHARS_U.or(ASCII_DIGIT).or(ch -> 45 == ch || 183 == ch || 768 <= ch && ch <= 879 || 8255 <= ch && ch <= 8256);

    public static final String escape(String value) {
        int[] codePoints;
        StringBuilder escaped = new StringBuilder();
        for (int ch : codePoints = value.codePoints().toArray()) {
            if (ch == 9) {
                escaped.append("\\t");
                continue;
            }
            if (ch == 8) {
                escaped.append("\\b");
                continue;
            }
            if (ch == 10) {
                escaped.append("\\n");
                continue;
            }
            if (ch == 13) {
                escaped.append("\\r");
                continue;
            }
            if (ch == 12) {
                escaped.append("\\f");
                continue;
            }
            if (ch == 34) {
                escaped.append("\\\"");
                continue;
            }
            if (ch == 92) {
                escaped.append("\\\\");
                continue;
            }
            if (ch >= 0 && ch <= 31 || ch == 127) {
                escaped.append(String.format("\\u%04X", ch));
                continue;
            }
            escaped.appendCodePoint(ch);
        }
        return escaped.toString();
    }

    private NQuadsAlphabet() {
    }
}

