/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.util.FmtUtils;

public class NodeValueLangDir
extends NodeValue {
    private final String string;
    private final String lang;
    private final TextDirection textDir;

    public NodeValueLangDir(String lex, String lang, String textDirStr) {
        this.string = Objects.requireNonNull(lex);
        this.lang = Objects.requireNonNull(lang);
        if (lang.isEmpty()) {
            throw new IllegalArgumentException("lang is the empty string");
        }
        Objects.requireNonNull(textDirStr);
        this.textDir = TextDirection.createOrNull((String)textDirStr);
        if (this.textDir == null) {
            throw new IllegalArgumentException("base direction is not valid : '" + textDirStr + "'");
        }
    }

    public NodeValueLangDir(String lex, String lang, TextDirection textDir) {
        this.string = Objects.requireNonNull(lex);
        this.lang = Objects.requireNonNull(lang);
        if (lang.isEmpty()) {
            throw new IllegalArgumentException("lang is the empty string");
        }
        this.textDir = Objects.requireNonNull(textDir);
    }

    public NodeValueLangDir(Node n) {
        super(Objects.requireNonNull(n));
        this.string = n.getLiteralLexicalForm();
        this.lang = n.getLiteralLanguage();
        this.textDir = n.getLiteralBaseDirection();
    }

    @Override
    public boolean isLangString() {
        return true;
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public String getLangDir() {
        return this.textDir.direction();
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    protected Node makeNode() {
        return NodeFactory.createLiteralDirLang((String)this.string, (String)this.lang, (TextDirection)this.textDir);
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return FmtUtils.stringForNode(this.getNode());
        }
        return "'" + this.getString() + "'@" + this.lang + "--" + this.textDir.direction();
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

