/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.io.JSWriter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class RowSetWriterJSON
implements RowSetWriter {
    public static RowSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_JSON)) {
            throw new ResultSetException("ResultSetWriter for JSON asked for a " + String.valueOf(lang));
        }
        return new RowSetWriterJSON();
    };

    private RowSetWriterJSON() {
    }

    @Override
    public void write(Writer out, RowSet rowSet, Context context2) {
        throw new UnsupportedOperationException("Writing JSON results to a java.io.Writer. Use an OutputStream.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream outStream, boolean result, Context context2) {
        try {
            JSWriter out = new JSWriter(outStream);
            out.startOutput();
            out.startObject();
            out.key("head");
            out.startObject();
            out.finishObject();
            out.pair("boolean", result);
            out.finishObject();
            out.finishOutput();
        }
        finally {
            IO.flush((OutputStream)outStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream outStream, RowSet rowSet, Context context2) {
        IndentedWriter out = new IndentedWriter(outStream);
        try {
            ResultSetWriterTableJSON x = new ResultSetWriterTableJSON(out, context2);
            x.write(rowSet);
        }
        finally {
            IO.flush((AWriter)out);
        }
    }

    static class ResultSetWriterTableJSON {
        private final NodeToLabel labels;
        private final IndentedWriter out;
        private static final boolean MultiLineValues = false;
        private static final boolean MultiLineVarNames = false;
        private static final int MainIndent = 2;
        private static final int VarIndent = 2;
        private static final int OuterIndent = Math.min(2, 2);

        private ResultSetWriterTableJSON(OutputStream outStream, Context context2) {
            this(new IndentedWriter(outStream), context2);
        }

        private ResultSetWriterTableJSON(IndentedWriter indentedOut, Context context2) {
            this.out = indentedOut;
            this.out.setUnitIndent(2);
            boolean outputGraphBNodeLabels = context2 != null && context2.isTrue(ARQ.outputGraphBNodeLabels);
            this.labels = outputGraphBNodeLabels ? SyntaxLabels.createNodeToLabelAsGiven() : SyntaxLabels.createNodeToLabel();
        }

        private void write(RowSet rowSet) {
            ResultSetWriterTableJSON.print(this.out, "{");
            this.out.incIndent(OuterIndent);
            this.writeHeader(rowSet);
            ResultSetWriterTableJSON.println(this.out, " ,");
            this.writeRows(rowSet);
            this.out.decIndent(OuterIndent);
            ResultSetWriterTableJSON.println(this.out, "}");
        }

        private void writeRows(RowSet rowSet) {
            ResultSetWriterTableJSON.println(this.out, ResultSetWriterTableJSON.quoteName("results"), ": {");
            ResultSetWriterTableJSON.incIndent(this.out);
            ResultSetWriterTableJSON.println(this.out, ResultSetWriterTableJSON.quoteName("bindings"), ": [");
            ResultSetWriterTableJSON.incIndent(this.out);
            boolean firstRow = true;
            while (rowSet.hasNext()) {
                Binding binding = rowSet.next();
                if (!firstRow) {
                    ResultSetWriterTableJSON.println(this.out, " ,");
                }
                this.writeRow(this.out, rowSet, binding);
                firstRow = false;
            }
            ResultSetWriterTableJSON.println(this.out, new String[0]);
            ResultSetWriterTableJSON.decIndent(this.out);
            ResultSetWriterTableJSON.println(this.out, "]");
            ResultSetWriterTableJSON.decIndent(this.out);
            ResultSetWriterTableJSON.println(this.out, "}");
        }

        private void writeHeader(RowSet rs) {
            ResultSetWriterTableJSON.println(this.out, ResultSetWriterTableJSON.quoteName("head"), ": {");
            ResultSetWriterTableJSON.incIndent(this.out);
            ResultSetWriterTableJSON.writeHeaderLink(this.out, rs);
            ResultSetWriterTableJSON.writeHeaderVars(this.out, rs);
            ResultSetWriterTableJSON.decIndent(this.out);
            ResultSetWriterTableJSON.print(this.out, "}");
        }

        private static void writeHeaderLink(IndentedWriter out, RowSet rs) {
        }

        private static void writeHeaderVars(IndentedWriter out, RowSet rs) {
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("vars"), ": [ ");
            ResultSetWriterTableJSON.incIndent(out);
            Iterator<Var> iter = rs.getResultVars().iterator();
            while (iter.hasNext()) {
                String varname = iter.next().getVarName();
                ResultSetWriterTableJSON.print(out, "\"", varname, "\"");
                if (!iter.hasNext()) continue;
                ResultSetWriterTableJSON.print(out, " , ");
            }
            ResultSetWriterTableJSON.decIndent(out);
            ResultSetWriterTableJSON.println(out, " ]");
        }

        private void writeRow(IndentedWriter out, RowSet rowSet, Binding binding) {
            ResultSetWriterTableJSON.print(out, "{ ");
            out.incIndent(2);
            boolean firstInRow = true;
            for (Var var : rowSet.getResultVars()) {
                Node value = binding.get(var);
                if (value == null) continue;
                if (!firstInRow) {
                    ResultSetWriterTableJSON.print(out, " ,");
                }
                this.writeVarValue(out, var, value, firstInRow);
                firstInRow = false;
            }
            ResultSetWriterTableJSON.println(out, new String[0]);
            out.decIndent(2);
            ResultSetWriterTableJSON.print(out, "}");
        }

        private void writeVarValue(IndentedWriter out, Var var, Node value, boolean firstInRow) {
            if (value == null) {
                return;
            }
            ResultSetWriterTableJSON.println(out, new String[0]);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quote(var.getVarName()), ": ");
            this.writeValue(out, value, false);
        }

        private void writeValue(IndentedWriter out, Node value, boolean multiLine) {
            if (multiLine || value.isTripleTerm()) {
                ResultSetWriterTableJSON.println(out, "{");
            } else {
                ResultSetWriterTableJSON.print(out, "{ ");
            }
            ResultSetWriterTableJSON.incIndent(out);
            if (value.isLiteral()) {
                this.writeValueLiteral(out, value, multiLine);
            } else if (value.isURI()) {
                this.writeValueURI(out, value, multiLine);
            } else if (value.isBlank()) {
                this.writeValueBlankNode(out, value, multiLine);
            } else if (value.isTripleTerm()) {
                this.writeValueNodeTriple(out, value, multiLine);
            } else if (value.isNodeGraph()) {
                this.writeValueNodeGraph(out, value, multiLine);
            } else {
                Log.warn(RowSetWriterJSON.class, (String)("Unknown RDFNode type in result set: " + String.valueOf(value.getClass())));
            }
            if (multiLine || value.isTripleTerm()) {
                ResultSetWriterTableJSON.println(out, new String[0]);
            } else {
                ResultSetWriterTableJSON.print(out, " ");
            }
            ResultSetWriterTableJSON.decIndent(out);
            ResultSetWriterTableJSON.print(out, "}");
        }

        private void writeValueUnbound(IndentedWriter out, boolean multiLine) {
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("type"), ": ", ResultSetWriterTableJSON.quote("undef"), " , ");
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("value"), ": null");
        }

        private void writeValueLiteral(IndentedWriter out, Node literal, boolean multiLine) {
            String datatype = literal.getLiteralDatatypeURI();
            if (Util.isSimpleString((Node)literal) || Util.isLangString((Node)literal) || Util.isDirLangString((Node)literal)) {
                String lang = literal.getLiteralLanguage();
                TextDirection direction = literal.getLiteralBaseDirection();
                ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("type"), ": ", ResultSetWriterTableJSON.quote("literal"), " , ");
                if (multiLine) {
                    ResultSetWriterTableJSON.println(out, new String[0]);
                }
                if (lang != null && !lang.equals("")) {
                    ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("xml:lang"), ": ", ResultSetWriterTableJSON.quote(lang), " , ");
                    if (multiLine) {
                        ResultSetWriterTableJSON.println(out, new String[0]);
                    }
                }
                if (direction != null) {
                    ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("its:dir"), ": ", ResultSetWriterTableJSON.quote(direction.direction()), " , ");
                    if (multiLine) {
                        ResultSetWriterTableJSON.println(out, new String[0]);
                    }
                }
            } else {
                ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("type"), ": ", ResultSetWriterTableJSON.quote("literal"), " , ");
                ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("datatype"), ": ", ResultSetWriterTableJSON.quote(datatype), " , ");
                if (multiLine) {
                    ResultSetWriterTableJSON.println(out, new String[0]);
                }
            }
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("value"), ": ", ResultSetWriterTableJSON.quote(literal.getLiteralLexicalForm()));
        }

        private void writeValueBlankNode(IndentedWriter out, Node resource, boolean multiLine) {
            String label = (String)this.labels.get(null, resource);
            label = label.substring(2);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("type"), ": ", ResultSetWriterTableJSON.quote("bnode"), " , ");
            if (multiLine) {
                ResultSetWriterTableJSON.println(out, new String[0]);
            }
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("value"), ": ", ResultSetWriterTableJSON.quote(label));
        }

        private void writeValueURI(IndentedWriter out, Node resource, boolean multiLine) {
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("type"), ": ", ResultSetWriterTableJSON.quote("uri"), " , ");
            if (multiLine) {
                ResultSetWriterTableJSON.println(out, new String[0]);
            }
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("value"), ": ", ResultSetWriterTableJSON.quote(resource.getURI()));
        }

        private void writeValueNodeTriple(IndentedWriter out, Node value, boolean multiLine) {
            Triple triple = value.getTriple();
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("type"), ": ", ResultSetWriterTableJSON.quote("triple"), " , ");
            ResultSetWriterTableJSON.println(out, new String[0]);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("value"), ": ");
            boolean multiLineInnerValue = multiLine;
            ResultSetWriterTableJSON.println(out, "{");
            ResultSetWriterTableJSON.incIndent(out);
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("subject"), ": ");
            ResultSetWriterTableJSON.print(out, " ");
            this.writeValue(out, triple.getSubject(), multiLineInnerValue);
            ResultSetWriterTableJSON.println(out, " ,");
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("predicate"), ": ");
            this.writeValue(out, triple.getPredicate(), multiLineInnerValue);
            ResultSetWriterTableJSON.println(out, " ,");
            ResultSetWriterTableJSON.print(out, ResultSetWriterTableJSON.quoteName("object"), ": ");
            ResultSetWriterTableJSON.print(out, "  ");
            this.writeValue(out, triple.getObject(), multiLineInnerValue);
            ResultSetWriterTableJSON.decIndent(out);
            ResultSetWriterTableJSON.println(out, new String[0]);
            ResultSetWriterTableJSON.print(out, "}");
        }

        private void writeValueNodeGraph(IndentedWriter out, Node value, boolean multiLine) {
            throw new UnsupportedOperationException("Graph terms");
        }

        private static String quote(String string) {
            return JSWriter.outputQuotedString(string);
        }

        private static String quoteName(String string) {
            return ResultSetWriterTableJSON.quote(string);
        }

        private static void incIndent(IndentedWriter out) {
            out.incIndent();
        }

        private static void decIndent(IndentedWriter out) {
            out.decIndent();
        }

        private static void print(IndentedWriter out, String ... strings) {
            for (String s : strings) {
                out.print(s);
            }
        }

        private static void println(IndentedWriter out, String ... strings) {
            ResultSetWriterTableJSON.print(out, strings);
            out.println();
        }
    }
}

