/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.mailbox.tools.indexer.ReIndexingContextInformationDTO;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;
import org.apache.mailbox.tools.indexer.SingleMailboxReindexingTask;

public class SingleMailboxReindexingTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final ReIndexingContextInformationDTO reIndexingContextInformationDTO;
    private final String mailboxId;

    public static AdditionalInformationDTOModule<SingleMailboxReindexingTask.AdditionalInformation, SingleMailboxReindexingTaskAdditionalInformationDTO> module(MailboxId.Factory factory) {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(SingleMailboxReindexingTask.AdditionalInformation.class).convertToDTO(SingleMailboxReindexingTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new SingleMailboxReindexingTask.AdditionalInformation(factory.fromString(dto.getMailboxId()), dto.getSuccessfullyReprocessedMailCount(), dto.getFailedReprocessedMailCount(), ReIndexingContextInformationDTO.deserializeFailures(factory, dto.getMessageFailures(), dto.getMailboxFailures().orElse((List<String>)ImmutableList.of())), dto.getTimestamp(), dto.getRunningOptions().map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT))).toDTOConverter((details, type) -> new SingleMailboxReindexingTaskAdditionalInformationDTO(type, details.getMailboxId(), details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), Optional.empty(), Optional.of(ReIndexingContextInformationDTO.serializeFailures(details.failures())), Optional.of((List)details.failures().mailboxFailures().stream().map(MailboxId::serialize).collect(ImmutableList.toImmutableList())), details.timestamp(), Optional.of(RunningOptionsDTO.toDTO(details.getRunningOptions())))).typeName(SingleMailboxReindexingTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    @JsonCreator
    private SingleMailboxReindexingTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") Optional<List<ReIndexingContextInformationDTO.ReindexingFailureDTO>> failures, @JsonProperty(value="messageFailures") Optional<List<ReIndexingContextInformationDTO.ReindexingFailureDTO>> messageFailures, @JsonProperty(value="mailboxFailures") Optional<List<String>> mailboxFailures, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
        this.mailboxId = mailboxId;
        this.reIndexingContextInformationDTO = new ReIndexingContextInformationDTO(type, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, messageFailures, mailboxFailures, timestamp, runningOptions);
    }

    public String getType() {
        return this.reIndexingContextInformationDTO.getType();
    }

    public Instant getTimestamp() {
        return this.reIndexingContextInformationDTO.getTimestamp();
    }

    public String getMailboxId() {
        return this.mailboxId;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.reIndexingContextInformationDTO.getSuccessfullyReprocessedMailCount();
    }

    public int getFailedReprocessedMailCount() {
        return this.reIndexingContextInformationDTO.getFailedReprocessedMailCount();
    }

    public List<ReIndexingContextInformationDTO.ReindexingFailureDTO> getMessageFailures() {
        return this.reIndexingContextInformationDTO.getMessageFailures();
    }

    public Optional<List<String>> getMailboxFailures() {
        return this.reIndexingContextInformationDTO.getMailboxFailures();
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.reIndexingContextInformationDTO.getRunningOptions();
    }
}

