/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.inject.Inject;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.util.Optional;
import org.apache.james.util.html.HtmlTextExtractor;

public class MimeMessageBodyGenerator {
    public static final String ALTERNATIVE = "alternative";
    public static final String EMPTY_TEXT = "";
    private final HtmlTextExtractor htmlTextExtractor;

    @Inject
    @VisibleForTesting
    public MimeMessageBodyGenerator(HtmlTextExtractor htmlTextExtractor) {
        this.htmlTextExtractor = htmlTextExtractor;
    }

    public MimeMessage from(MimeMessage messageHoldingHeaders, Optional<String> plainText, Optional<String> htmlText) throws MessagingException {
        Preconditions.checkNotNull((Object)messageHoldingHeaders);
        Preconditions.checkNotNull(plainText);
        Preconditions.checkNotNull(htmlText);
        if (htmlText.isPresent()) {
            messageHoldingHeaders.setContent(this.generateMultipart(htmlText.get(), plainText));
        } else {
            messageHoldingHeaders.setText(plainText.orElse(EMPTY_TEXT));
        }
        return messageHoldingHeaders;
    }

    private Multipart generateMultipart(String htmlText, Optional<String> plainText) throws MessagingException {
        try {
            MimeMultipart multipart = new MimeMultipart(ALTERNATIVE);
            this.addTextPart((Multipart)multipart, htmlText, "text/html");
            this.addTextPart((Multipart)multipart, this.retrievePlainTextMessage(plainText, htmlText), "text/plain");
            return multipart;
        }
        catch (IOException e) {
            throw new MessagingException("Cannot read specified content", (Exception)e);
        }
    }

    private Multipart addTextPart(Multipart multipart, String text, String contentType) throws MessagingException, IOException {
        MimeBodyPart textReasonPart = new MimeBodyPart();
        textReasonPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(text, contentType + "; charset=UTF-8")));
        multipart.addBodyPart((BodyPart)textReasonPart);
        return multipart;
    }

    private String retrievePlainTextMessage(Optional<String> plainText, String htmlText) {
        return plainText.filter(text -> !text.isBlank()).orElseGet(() -> this.htmlTextExtractor.toPlainText(htmlText));
    }
}

