/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.search.ScoreMode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RescoreQuery
implements PlainJsonSerializable {
    private final Query query;
    @Nullable
    private final Double queryWeight;
    @Nullable
    private final Double rescoreQueryWeight;
    @Nullable
    private final ScoreMode scoreMode;
    public static final JsonpDeserializer<RescoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RescoreQuery::setupRescoreQueryDeserializer);

    private RescoreQuery(Builder builder) {
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.queryWeight = builder.queryWeight;
        this.rescoreQueryWeight = builder.rescoreQueryWeight;
        this.scoreMode = builder.scoreMode;
    }

    public static RescoreQuery of(Function<Builder, ObjectBuilder<RescoreQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Double queryWeight() {
        return this.queryWeight;
    }

    @Nullable
    public final Double rescoreQueryWeight() {
        return this.rescoreQueryWeight;
    }

    @Nullable
    public final ScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rescore_query");
        this.query.serialize(generator, mapper);
        if (this.queryWeight != null) {
            generator.writeKey("query_weight");
            generator.write(this.queryWeight.doubleValue());
        }
        if (this.rescoreQueryWeight != null) {
            generator.writeKey("rescore_query_weight");
            generator.write(this.rescoreQueryWeight.doubleValue());
        }
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    protected static void setupRescoreQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::query, Query._DESERIALIZER, "rescore_query");
        op.add(Builder::queryWeight, JsonpDeserializer.doubleDeserializer(), "query_weight");
        op.add(Builder::rescoreQueryWeight, JsonpDeserializer.doubleDeserializer(), "rescore_query_weight");
        op.add(Builder::scoreMode, ScoreMode._DESERIALIZER, "score_mode");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RescoreQuery> {
        private Query query;
        @Nullable
        private Double queryWeight;
        @Nullable
        private Double rescoreQueryWeight;
        @Nullable
        private ScoreMode scoreMode;

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder queryWeight(@Nullable Double value) {
            this.queryWeight = value;
            return this;
        }

        public final Builder rescoreQueryWeight(@Nullable Double value) {
            this.rescoreQueryWeight = value;
            return this;
        }

        public final Builder scoreMode(@Nullable ScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        public RescoreQuery build() {
            this._checkSingleUse();
            return new RescoreQuery(this);
        }
    }
}

