/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ManageDsaITRequestControl
extends Control {
    @NotNull
    public static final String MANAGE_DSA_IT_REQUEST_OID = "2.16.840.1.113730.3.4.2";
    private static final long serialVersionUID = -4540943247829123783L;

    public ManageDsaITRequestControl() {
        super(MANAGE_DSA_IT_REQUEST_OID, false, null);
    }

    public ManageDsaITRequestControl(boolean isCritical) {
        super(MANAGE_DSA_IT_REQUEST_OID, isCritical, null);
    }

    public ManageDsaITRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MANAGE_DSA_IT_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_MANAGE_DSAIT_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", MANAGE_DSA_IT_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_MANAGE_DSAIT_REQUEST.get()), new JSONField("criticality", this.isCritical()));
    }

    @NotNull
    public static ManageDsaITRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, false, false);
        return new ManageDsaITRequestControl(jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ManageDsaITRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

