/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.dlp.eventsourcing.cassandra.DLPConfigurationItemDTO;
import org.apache.james.dlp.eventsourcing.events.ConfigurationItemsAdded;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.dto.EventDTO;

class DLPConfigurationItemAddedDTO
implements EventDTO {
    private final String type;
    private final int eventId;
    private final String aggregateId;
    private final List<DLPConfigurationItemDTO> configurationItems;

    public static DLPConfigurationItemAddedDTO from(ConfigurationItemsAdded event, String type) {
        return new DLPConfigurationItemAddedDTO(type, event.eventId().serialize(), event.getAggregateId().asAggregateKey(), DLPConfigurationItemDTO.from(event.getRules()));
    }

    @JsonCreator
    private DLPConfigurationItemAddedDTO(@JsonProperty(value="type") String type, @JsonProperty(value="eventId") int eventId, @JsonProperty(value="aggregateId") String aggregateId, @JsonProperty(value="configurationItems") List<DLPConfigurationItemDTO> configurationItems) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)aggregateId);
        Preconditions.checkNotNull(configurationItems);
        Preconditions.checkArgument((!configurationItems.isEmpty() ? 1 : 0) != 0);
        this.type = type;
        this.eventId = eventId;
        this.aggregateId = aggregateId;
        this.configurationItems = configurationItems;
    }

    public String getType() {
        return this.type;
    }

    public long getEventId() {
        return this.eventId;
    }

    public String getAggregateId() {
        return this.aggregateId;
    }

    public List<DLPConfigurationItemDTO> getConfigurationItems() {
        return this.configurationItems;
    }

    @JsonIgnore
    public ConfigurationItemsAdded toEvent() {
        return new ConfigurationItemsAdded(DLPAggregateId.parse((String)this.aggregateId), EventId.fromSerialized((int)this.eventId), DLPConfigurationItemDTO.fromDTOs(this.configurationItems));
    }

    public final boolean equals(Object o) {
        if (o instanceof DLPConfigurationItemAddedDTO) {
            DLPConfigurationItemAddedDTO that = (DLPConfigurationItemAddedDTO)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.type, that.type) && Objects.equals(this.aggregateId, that.aggregateId) && Objects.equals(this.configurationItems, that.configurationItems);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.type, this.eventId, this.aggregateId, this.configurationItems);
    }
}

