/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.Flags;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.JPAProperty;
import org.apache.james.mailbox.jpa.mail.model.JPAUserFlag;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.FlagsFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumns;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.UserException;

@IdClass(value=MailboxIdUidKey.class)
@NamedQueries(value={@NamedQuery(name="findRecentMessageUidsInMailbox", query="SELECT message.uid FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.recent = TRUE ORDER BY message.uid ASC"), @NamedQuery(name="findUnseenMessagesInMailboxOrderByUid", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.seen = FALSE ORDER BY message.uid ASC"), @NamedQuery(name="findMessagesInMailbox", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam ORDER BY message.uid ASC"), @NamedQuery(name="findMessagesInMailboxBetweenUIDs", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid BETWEEN :fromParam AND :toParam ORDER BY message.uid ASC"), @NamedQuery(name="findMessagesInMailboxWithUID", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid=:uidParam ORDER BY message.uid ASC"), @NamedQuery(name="findMessagesInMailboxAfterUID", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid>=:uidParam ORDER BY message.uid ASC"), @NamedQuery(name="findDeletedMessagesInMailbox", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.deleted=TRUE ORDER BY message.uid ASC"), @NamedQuery(name="findDeletedMessagesInMailboxBetweenUIDs", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid BETWEEN :fromParam AND :toParam AND message.deleted=TRUE ORDER BY message.uid ASC"), @NamedQuery(name="findDeletedMessagesInMailboxWithUID", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid=:uidParam AND message.deleted=TRUE ORDER BY message.uid ASC"), @NamedQuery(name="findDeletedMessagesInMailboxAfterUID", query="SELECT message FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid>=:uidParam AND message.deleted=TRUE ORDER BY message.uid ASC"), @NamedQuery(name="deleteMessagesInMailbox", query="DELETE FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam"), @NamedQuery(name="deleteMessagesInMailboxBetweenUIDs", query="DELETE FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid BETWEEN :fromParam AND :toParam"), @NamedQuery(name="deleteMessagesInMailboxWithUID", query="DELETE FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid=:uidParam"), @NamedQuery(name="deleteMessagesInMailboxAfterUID", query="DELETE FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.uid>=:uidParam"), @NamedQuery(name="countUnseenMessagesInMailbox", query="SELECT COUNT(message) FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam AND message.seen=FALSE"), @NamedQuery(name="countMessagesInMailbox", query="SELECT COUNT(message) FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam"), @NamedQuery(name="deleteMessages", query="DELETE FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam"), @NamedQuery(name="findLastUidInMailbox", query="SELECT message.uid FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam ORDER BY message.uid DESC"), @NamedQuery(name="findHighestModSeqInMailbox", query="SELECT message.modSeq FROM MailboxMessage message WHERE message.mailbox.mailboxId = :idParam ORDER BY message.modSeq DESC")})
@MappedSuperclass
public abstract class AbstractJPAMailboxMessage
implements MailboxMessage,
PersistenceCapable {
    private static final String TOSTRING_SEPARATOR = " ";
    @Id
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE}, fetch=FetchType.EAGER)
    @Column(name="MAILBOX_ID", nullable=true)
    private JPAMailbox mailbox;
    @Id
    @Column(name="MAIL_UID")
    private long uid;
    @Index
    @Column(name="MAIL_MODSEQ")
    private long modSeq;
    @Basic(optional=false)
    @Column(name="MAIL_DATE")
    private Date internalDate;
    @Basic(optional=false)
    @Column(name="MAIL_IS_ANSWERED", nullable=false)
    private boolean answered = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_DELETED", nullable=false)
    @Index
    private boolean deleted = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_DRAFT", nullable=false)
    private boolean draft = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_FLAGGED", nullable=false)
    private boolean flagged = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_RECENT", nullable=false)
    @Index
    private boolean recent = false;
    @Basic(optional=false)
    @Column(name="MAIL_IS_SEEN", nullable=false)
    @Index
    private boolean seen = false;
    @Basic(optional=false)
    @Column(name="MAIL_BODY_START_OCTET", nullable=false)
    private int bodyStartOctet;
    @Basic(optional=false)
    @Column(name="MAIL_CONTENT_OCTETS_COUNT", nullable=false)
    private long contentOctets;
    @Basic(optional=true)
    @Column(name="MAIL_MIME_TYPE", nullable=true, length=200)
    private String mediaType;
    @Basic(optional=true)
    @Column(name="MAIL_MIME_SUBTYPE", nullable=true, length=200)
    private String subType;
    @Basic(optional=true)
    @Column(name="MAIL_TEXTUAL_LINE_COUNT", nullable=true)
    private Long textualLineCount;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="line")
    @ElementJoinColumns(value={@ElementJoinColumn(name="MAILBOX_ID", referencedColumnName="MAILBOX_ID"), @ElementJoinColumn(name="MAIL_UID", referencedColumnName="MAIL_UID")})
    private List<JPAProperty> properties;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @OrderBy(value="id")
    @ElementJoinColumns(value={@ElementJoinColumn(name="MAILBOX_ID", referencedColumnName="MAILBOX_ID"), @ElementJoinColumn(name="MAIL_UID", referencedColumnName="MAIL_UID")})
    private List<JPAUserFlag> userFlags;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$JPAMailbox;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage;
    private transient Object pcDetachedState;

    public AbstractJPAMailboxMessage() {
    }

    public AbstractJPAMailboxMessage(JPAMailbox mailbox, Date internalDate, Flags flags, long contentOctets, int bodyStartOctet, PropertyBuilder propertyBuilder) {
        this.mailbox = mailbox;
        this.internalDate = internalDate;
        this.userFlags = new ArrayList<JPAUserFlag>();
        this.setFlags(flags);
        this.contentOctets = contentOctets;
        this.bodyStartOctet = bodyStartOctet;
        Properties properties = propertyBuilder.build();
        this.textualLineCount = properties.getTextualLineCount();
        this.mediaType = properties.getMediaType();
        this.subType = properties.getSubType();
        List propertiesAsList = properties.toProperties();
        this.properties = new ArrayList<JPAProperty>(propertiesAsList.size());
        int order = 0;
        for (Property property : propertiesAsList) {
            this.properties.add(new JPAProperty(property, order++));
        }
    }

    public AbstractJPAMailboxMessage(JPAMailbox mailbox, MessageUid uid, ModSeq modSeq, MailboxMessage original) throws MailboxException {
        this.mailbox = mailbox;
        this.uid = uid.asLong();
        this.modSeq = modSeq.asLong();
        this.userFlags = new ArrayList<JPAUserFlag>();
        this.setFlags(original.createFlags());
        this.recent = true;
        this.contentOctets = original.getFullContentOctets();
        this.bodyStartOctet = (int)(original.getFullContentOctets() - original.getBodyOctets());
        this.internalDate = original.getInternalDate();
        this.textualLineCount = original.getTextualLineCount();
        this.mediaType = original.getMediaType();
        this.subType = original.getSubType();
        List properties = original.getProperties().toProperties();
        this.properties = new ArrayList<JPAProperty>(properties.size());
        int order = 0;
        for (Property property : properties) {
            this.properties.add(new JPAProperty(property, order++));
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getMailboxId().getRawId(), AbstractJPAMailboxMessage.pcGetuid(this)});
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractJPAMailboxMessage) {
            AbstractJPAMailboxMessage other = (AbstractJPAMailboxMessage)obj;
            return Objects.equal((Object)this.getMailboxId(), (Object)other.getMailboxId()) && Objects.equal((Object)AbstractJPAMailboxMessage.pcGetuid(this), (Object)other.getUid());
        }
        return false;
    }

    public ComposedMessageIdWithMetaData getComposedMessageIdWithMetaData() {
        return ComposedMessageIdWithMetaData.builder().modSeq(this.getModSeq()).flags(this.createFlags()).composedMessageId(new ComposedMessageId((MailboxId)AbstractJPAMailboxMessage.pcGetmailbox(this).getMailboxId(), this.getMessageId(), MessageUid.of((long)AbstractJPAMailboxMessage.pcGetuid(this)))).threadId(this.getThreadId()).build();
    }

    public ModSeq getModSeq() {
        return ModSeq.of((long)AbstractJPAMailboxMessage.pcGetmodSeq(this));
    }

    public void setModSeq(ModSeq modSeq) {
        AbstractJPAMailboxMessage.pcSetmodSeq(this, modSeq.asLong());
    }

    public String getMediaType() {
        return AbstractJPAMailboxMessage.pcGetmediaType(this);
    }

    public String getSubType() {
        return AbstractJPAMailboxMessage.pcGetsubType(this);
    }

    public Properties getProperties() {
        return new PropertyBuilder((List)AbstractJPAMailboxMessage.pcGetproperties(this).stream().map(JPAProperty::toProperty).collect(ImmutableList.toImmutableList())).build();
    }

    public Long getTextualLineCount() {
        return AbstractJPAMailboxMessage.pcGettextualLineCount(this);
    }

    public long getFullContentOctets() {
        return AbstractJPAMailboxMessage.pcGetcontentOctets(this);
    }

    protected int getBodyStartOctet() {
        return AbstractJPAMailboxMessage.pcGetbodyStartOctet(this);
    }

    public Date getInternalDate() {
        return AbstractJPAMailboxMessage.pcGetinternalDate(this);
    }

    public JPAId getMailboxId() {
        return this.getMailbox().getMailboxId();
    }

    public MessageUid getUid() {
        return MessageUid.of((long)AbstractJPAMailboxMessage.pcGetuid(this));
    }

    public boolean isAnswered() {
        return AbstractJPAMailboxMessage.pcGetanswered(this);
    }

    public boolean isDeleted() {
        return AbstractJPAMailboxMessage.pcGetdeleted(this);
    }

    public boolean isDraft() {
        return AbstractJPAMailboxMessage.pcGetdraft(this);
    }

    public boolean isFlagged() {
        return AbstractJPAMailboxMessage.pcGetflagged(this);
    }

    public boolean isRecent() {
        return AbstractJPAMailboxMessage.pcGetrecent(this);
    }

    public boolean isSeen() {
        return AbstractJPAMailboxMessage.pcGetseen(this);
    }

    public void setUid(MessageUid uid) {
        AbstractJPAMailboxMessage.pcSetuid(this, uid.asLong());
    }

    public long getHeaderOctets() {
        return AbstractJPAMailboxMessage.pcGetbodyStartOctet(this);
    }

    public void setFlags(Flags flags) {
        AbstractJPAMailboxMessage.pcSetanswered(this, flags.contains(Flags.Flag.ANSWERED));
        AbstractJPAMailboxMessage.pcSetdeleted(this, flags.contains(Flags.Flag.DELETED));
        AbstractJPAMailboxMessage.pcSetdraft(this, flags.contains(Flags.Flag.DRAFT));
        AbstractJPAMailboxMessage.pcSetflagged(this, flags.contains(Flags.Flag.FLAGGED));
        AbstractJPAMailboxMessage.pcSetrecent(this, flags.contains(Flags.Flag.RECENT));
        AbstractJPAMailboxMessage.pcSetseen(this, flags.contains(Flags.Flag.SEEN));
        String[] userflags = flags.getUserFlags();
        AbstractJPAMailboxMessage.pcGetuserFlags(this).clear();
        for (String userflag : userflags) {
            AbstractJPAMailboxMessage.pcGetuserFlags(this).add(new JPAUserFlag(userflag));
        }
    }

    public JPAMailbox getMailbox() {
        return AbstractJPAMailboxMessage.pcGetmailbox(this);
    }

    public Flags createFlags() {
        return FlagsFactory.createFlags((MailboxMessage)this, (String[])this.createUserFlags());
    }

    protected String[] createUserFlags() {
        return (String[])AbstractJPAMailboxMessage.pcGetuserFlags(this).stream().map(JPAUserFlag::getName).toArray(String[]::new);
    }

    public void setMailbox(JPAMailbox mailbox) {
        AbstractJPAMailboxMessage.pcSetmailbox(this, mailbox);
    }

    public InputStream getFullContent() throws IOException {
        return new SequenceInputStream(this.getHeaderContent(), this.getBodyContent());
    }

    public long getBodyOctets() {
        return this.getFullContentOctets() - (long)this.getBodyStartOctet();
    }

    public MessageId getMessageId() {
        return new DefaultMessageId();
    }

    public ThreadId getThreadId() {
        return new ThreadId(this.getMessageId());
    }

    public String toString() {
        return "message(mailboxId = " + this.getMailboxId() + " uid = " + AbstractJPAMailboxMessage.pcGetuid(this) + " internalDate = " + AbstractJPAMailboxMessage.pcGetinternalDate(this) + " answered = " + AbstractJPAMailboxMessage.pcGetanswered(this) + " deleted = " + AbstractJPAMailboxMessage.pcGetdeleted(this) + " draft = " + AbstractJPAMailboxMessage.pcGetdraft(this) + " flagged = " + AbstractJPAMailboxMessage.pcGetflagged(this) + " recent = " + AbstractJPAMailboxMessage.pcGetrecent(this) + " seen = " + AbstractJPAMailboxMessage.pcGetseen(this) + "  )";
    }

    public List<MessageAttachmentMetadata> getAttachments() {
        try {
            AtomicInteger counter = new AtomicInteger(0);
            return (List)new MessageParser().retrieveAttachments(this.getFullContent()).stream().map(Throwing.function(attachmentMetadata -> attachmentMetadata.asMessageAttachment(this.generateFixedAttachmentId(counter.incrementAndGet()), this.getMessageId())).sneakyThrow()).collect(ImmutableList.toImmutableList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AttachmentId generateFixedAttachmentId(int position) {
        return AttachmentId.from((String)(this.getMailboxId().serialize() + "-" + this.getUid().asLong() + "-" + position));
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"answered", "bodyStartOctet", "contentOctets", "deleted", "draft", "flagged", "internalDate", "mailbox", "mediaType", "modSeq", "properties", "recent", "seen", "subType", "textualLineCount", "uid", "userFlags"};
        Class[] classArray = new Class[17];
        classArray[0] = Boolean.TYPE;
        classArray[1] = Integer.TYPE;
        classArray[2] = Long.TYPE;
        classArray[3] = Boolean.TYPE;
        classArray[4] = Boolean.TYPE;
        classArray[5] = Boolean.TYPE;
        Class clazz = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AbstractJPAMailboxMessage.class$("java.util.Date"));
        classArray[6] = clazz;
        Class clazz2 = class$Lorg$apache$james$mailbox$jpa$mail$model$JPAMailbox != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$JPAMailbox : (class$Lorg$apache$james$mailbox$jpa$mail$model$JPAMailbox = AbstractJPAMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.JPAMailbox"));
        classArray[7] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractJPAMailboxMessage.class$("java.lang.String"));
        classArray[8] = clazz3;
        classArray[9] = Long.TYPE;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AbstractJPAMailboxMessage.class$("java.util.List"));
        classArray[10] = clazz4;
        classArray[11] = Boolean.TYPE;
        classArray[12] = Boolean.TYPE;
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractJPAMailboxMessage.class$("java.lang.String"));
        Class clazz5 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = AbstractJPAMailboxMessage.class$("java.lang.Long"));
        classArray[14] = clazz5;
        classArray[15] = Long.TYPE;
        classArray[16] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AbstractJPAMailboxMessage.class$("java.util.List"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 10, 26, 26, 26, 26, 26, 10};
        Class clazz6 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage = AbstractJPAMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractJPAMailboxMessage", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.answered = false;
        this.bodyStartOctet = 0;
        this.contentOctets = 0L;
        this.deleted = false;
        this.draft = false;
        this.flagged = false;
        this.internalDate = null;
        this.mailbox = null;
        this.mediaType = null;
        this.modSeq = 0L;
        this.properties = null;
        this.recent = false;
        this.seen = false;
        this.subType = null;
        this.textualLineCount = null;
        this.uid = 0L;
        this.userFlags = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 17;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.answered = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.bodyStartOctet = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.contentOctets = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.deleted = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.draft = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.flagged = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.internalDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.mailbox = (JPAMailbox)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.mediaType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.modSeq = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.properties = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.recent = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.seen = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.subType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.textualLineCount = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.uid = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.userFlags = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.answered);
                return;
            }
            case 1: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.bodyStartOctet);
                return;
            }
            case 2: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.contentOctets);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.deleted);
                return;
            }
            case 4: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.draft);
                return;
            }
            case 5: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.flagged);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.internalDate);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.mailbox);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.mediaType);
                return;
            }
            case 9: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.modSeq);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.properties);
                return;
            }
            case 11: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.recent);
                return;
            }
            case 12: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.seen);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.subType);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.textualLineCount);
                return;
            }
            case 15: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.uid);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.userFlags);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AbstractJPAMailboxMessage abstractJPAMailboxMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.answered = abstractJPAMailboxMessage.answered;
                return;
            }
            case 1: {
                this.bodyStartOctet = abstractJPAMailboxMessage.bodyStartOctet;
                return;
            }
            case 2: {
                this.contentOctets = abstractJPAMailboxMessage.contentOctets;
                return;
            }
            case 3: {
                this.deleted = abstractJPAMailboxMessage.deleted;
                return;
            }
            case 4: {
                this.draft = abstractJPAMailboxMessage.draft;
                return;
            }
            case 5: {
                this.flagged = abstractJPAMailboxMessage.flagged;
                return;
            }
            case 6: {
                this.internalDate = abstractJPAMailboxMessage.internalDate;
                return;
            }
            case 7: {
                this.mailbox = abstractJPAMailboxMessage.mailbox;
                return;
            }
            case 8: {
                this.mediaType = abstractJPAMailboxMessage.mediaType;
                return;
            }
            case 9: {
                this.modSeq = abstractJPAMailboxMessage.modSeq;
                return;
            }
            case 10: {
                this.properties = abstractJPAMailboxMessage.properties;
                return;
            }
            case 11: {
                this.recent = abstractJPAMailboxMessage.recent;
                return;
            }
            case 12: {
                this.seen = abstractJPAMailboxMessage.seen;
                return;
            }
            case 13: {
                this.subType = abstractJPAMailboxMessage.subType;
                return;
            }
            case 14: {
                this.textualLineCount = abstractJPAMailboxMessage.textualLineCount;
                return;
            }
            case 15: {
                this.uid = abstractJPAMailboxMessage.uid;
                return;
            }
            case 16: {
                this.userFlags = abstractJPAMailboxMessage.userFlags;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AbstractJPAMailboxMessage abstractJPAMailboxMessage = (AbstractJPAMailboxMessage)object;
        if (abstractJPAMailboxMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(abstractJPAMailboxMessage, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        int n = pcInheritedFieldCount;
        mailboxIdUidKey.mailbox = fieldSupplier.fetchLongField(7 + n);
        mailboxIdUidKey.uid = fieldSupplier.fetchLongField(15 + n);
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        Object object2;
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        JPAMailbox jPAMailbox = this.mailbox;
        mailboxIdUidKey.mailbox = jPAMailbox != null && (object2 = ((PersistenceCapable)jPAMailbox).pcNewObjectIdInstance()) != null ? ((LongId)object2).getId() : 0L;
        mailboxIdUidKey.uid = this.uid;
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        fieldConsumer.storeLongField(7 + pcInheritedFieldCount, mailboxIdUidKey.mailbox);
        fieldConsumer.storeLongField(15 + pcInheritedFieldCount, mailboxIdUidKey.uid);
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        if (this.pcStateManager == null) {
            return;
        }
        this.mailbox = (JPAMailbox)this.pcStateManager.getPCPrimaryKey((Object)mailboxIdUidKey, 7 + pcInheritedFieldCount);
        this.uid = mailboxIdUidKey.uid;
    }

    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage = AbstractJPAMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage"));
        return clazz;
    }

    public Object pcNewObjectIdInstance(Object object) {
        throw new IllegalArgumentException("The id type \"class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage$MailboxIdUidKey\" specified by persistent type \"class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage\" does not have a public class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage$MailboxIdUidKey(String) or class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage$MailboxIdUidKey(Class, String) constructor.");
    }

    public Object pcNewObjectIdInstance() {
        return new ObjectId(this.pcGetIDOwningClass(), (Object)new MailboxIdUidKey());
    }

    private static final boolean pcGetanswered(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.answered;
        }
        int n = pcInheritedFieldCount + 0;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.answered;
    }

    private static final void pcSetanswered(AbstractJPAMailboxMessage abstractJPAMailboxMessage, boolean bl) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.answered = bl;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 0, abstractJPAMailboxMessage.answered, bl, 0);
    }

    private static final int pcGetbodyStartOctet(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.bodyStartOctet;
        }
        int n = pcInheritedFieldCount + 1;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.bodyStartOctet;
    }

    private static final void pcSetbodyStartOctet(AbstractJPAMailboxMessage abstractJPAMailboxMessage, int n) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.bodyStartOctet = n;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingIntField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 1, abstractJPAMailboxMessage.bodyStartOctet, n, 0);
    }

    private static final long pcGetcontentOctets(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.contentOctets;
        }
        int n = pcInheritedFieldCount + 2;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.contentOctets;
    }

    private static final void pcSetcontentOctets(AbstractJPAMailboxMessage abstractJPAMailboxMessage, long l) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.contentOctets = l;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 2, abstractJPAMailboxMessage.contentOctets, l, 0);
    }

    private static final boolean pcGetdeleted(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.deleted;
        }
        int n = pcInheritedFieldCount + 3;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.deleted;
    }

    private static final void pcSetdeleted(AbstractJPAMailboxMessage abstractJPAMailboxMessage, boolean bl) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.deleted = bl;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 3, abstractJPAMailboxMessage.deleted, bl, 0);
    }

    private static final boolean pcGetdraft(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.draft;
        }
        int n = pcInheritedFieldCount + 4;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.draft;
    }

    private static final void pcSetdraft(AbstractJPAMailboxMessage abstractJPAMailboxMessage, boolean bl) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.draft = bl;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 4, abstractJPAMailboxMessage.draft, bl, 0);
    }

    private static final boolean pcGetflagged(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.flagged;
        }
        int n = pcInheritedFieldCount + 5;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.flagged;
    }

    private static final void pcSetflagged(AbstractJPAMailboxMessage abstractJPAMailboxMessage, boolean bl) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.flagged = bl;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 5, abstractJPAMailboxMessage.flagged, bl, 0);
    }

    private static final Date pcGetinternalDate(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.internalDate;
        }
        int n = pcInheritedFieldCount + 6;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.internalDate;
    }

    private static final void pcSetinternalDate(AbstractJPAMailboxMessage abstractJPAMailboxMessage, Date date) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.internalDate = date;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 6, (Object)abstractJPAMailboxMessage.internalDate, (Object)date, 0);
    }

    private static final JPAMailbox pcGetmailbox(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.mailbox;
        }
        int n = pcInheritedFieldCount + 7;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.mailbox;
    }

    private static final void pcSetmailbox(AbstractJPAMailboxMessage abstractJPAMailboxMessage, JPAMailbox jPAMailbox) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.mailbox = jPAMailbox;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 7, (Object)abstractJPAMailboxMessage.mailbox, (Object)jPAMailbox, 0);
    }

    private static final String pcGetmediaType(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.mediaType;
        }
        int n = pcInheritedFieldCount + 8;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.mediaType;
    }

    private static final void pcSetmediaType(AbstractJPAMailboxMessage abstractJPAMailboxMessage, String string) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.mediaType = string;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingStringField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 8, abstractJPAMailboxMessage.mediaType, string, 0);
    }

    private static final long pcGetmodSeq(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.modSeq;
        }
        int n = pcInheritedFieldCount + 9;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.modSeq;
    }

    private static final void pcSetmodSeq(AbstractJPAMailboxMessage abstractJPAMailboxMessage, long l) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.modSeq = l;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 9, abstractJPAMailboxMessage.modSeq, l, 0);
    }

    private static final List pcGetproperties(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.properties;
        }
        int n = pcInheritedFieldCount + 10;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.properties;
    }

    private static final void pcSetproperties(AbstractJPAMailboxMessage abstractJPAMailboxMessage, List list) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.properties = list;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 10, abstractJPAMailboxMessage.properties, (Object)list, 0);
    }

    private static final boolean pcGetrecent(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.recent;
        }
        int n = pcInheritedFieldCount + 11;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.recent;
    }

    private static final void pcSetrecent(AbstractJPAMailboxMessage abstractJPAMailboxMessage, boolean bl) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.recent = bl;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 11, abstractJPAMailboxMessage.recent, bl, 0);
    }

    private static final boolean pcGetseen(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.seen;
        }
        int n = pcInheritedFieldCount + 12;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.seen;
    }

    private static final void pcSetseen(AbstractJPAMailboxMessage abstractJPAMailboxMessage, boolean bl) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.seen = bl;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 12, abstractJPAMailboxMessage.seen, bl, 0);
    }

    private static final String pcGetsubType(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.subType;
        }
        int n = pcInheritedFieldCount + 13;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.subType;
    }

    private static final void pcSetsubType(AbstractJPAMailboxMessage abstractJPAMailboxMessage, String string) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.subType = string;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingStringField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 13, abstractJPAMailboxMessage.subType, string, 0);
    }

    private static final Long pcGettextualLineCount(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.textualLineCount;
        }
        int n = pcInheritedFieldCount + 14;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.textualLineCount;
    }

    private static final void pcSettextualLineCount(AbstractJPAMailboxMessage abstractJPAMailboxMessage, Long l) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.textualLineCount = l;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 14, (Object)abstractJPAMailboxMessage.textualLineCount, (Object)l, 0);
    }

    private static final long pcGetuid(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.uid;
        }
        int n = pcInheritedFieldCount + 15;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.uid;
    }

    private static final void pcSetuid(AbstractJPAMailboxMessage abstractJPAMailboxMessage, long l) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.uid = l;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 15, abstractJPAMailboxMessage.uid, l, 0);
    }

    private static final List pcGetuserFlags(AbstractJPAMailboxMessage abstractJPAMailboxMessage) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            return abstractJPAMailboxMessage.userFlags;
        }
        int n = pcInheritedFieldCount + 16;
        abstractJPAMailboxMessage.pcStateManager.accessingField(n);
        return abstractJPAMailboxMessage.userFlags;
    }

    private static final void pcSetuserFlags(AbstractJPAMailboxMessage abstractJPAMailboxMessage, List list) {
        if (abstractJPAMailboxMessage.pcStateManager == null) {
            abstractJPAMailboxMessage.userFlags = list;
            return;
        }
        abstractJPAMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMailboxMessage, pcInheritedFieldCount + 16, abstractJPAMailboxMessage.userFlags, (Object)list, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    @Embeddable
    public static class MailboxIdUidKey
    implements Serializable,
    PersistenceCapable {
        private static final long serialVersionUID = 7847632032426660997L;
        public long mailbox;
        public long uid;
        private static int pcInheritedFieldCount;
        private static String[] pcFieldNames;
        private static Class[] pcFieldTypes;
        private static byte[] pcFieldFlags;
        private static Class pcPCSuperclass;
        protected transient StateManager pcStateManager;
        static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage$MailboxIdUidKey;
        private transient Object pcDetachedState;

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (int)(MailboxIdUidKey.pcGetmailbox(this) ^ MailboxIdUidKey.pcGetmailbox(this) >>> 32);
            result = 31 * result + (int)(MailboxIdUidKey.pcGetuid(this) ^ MailboxIdUidKey.pcGetuid(this) >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MailboxIdUidKey other = (MailboxIdUidKey)obj;
            if (MailboxIdUidKey.pcGetmailbox(this) != MailboxIdUidKey.pcGetmailbox(other)) {
                return false;
            }
            return MailboxIdUidKey.pcGetuid(this) == MailboxIdUidKey.pcGetuid(other);
        }

        public int pcGetEnhancementContractVersion() {
            return 196634845;
        }

        static {
            pcFieldNames = new String[]{"mailbox", "uid"};
            Class[] classArray = new Class[2];
            classArray[0] = Long.TYPE;
            classArray[1] = Long.TYPE;
            pcFieldTypes = classArray;
            pcFieldFlags = new byte[]{26, 26};
            Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage$MailboxIdUidKey != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage$MailboxIdUidKey : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage$MailboxIdUidKey = MailboxIdUidKey.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage$MailboxIdUidKey"));
            PCRegistry.register((Class)clazz, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, null, (PersistenceCapable)new MailboxIdUidKey());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        protected void pcClearFields() {
            this.mailbox = 0L;
            this.uid = 0L;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
            MailboxIdUidKey mailboxIdUidKey = new MailboxIdUidKey();
            if (bl) {
                mailboxIdUidKey.pcClearFields();
            }
            mailboxIdUidKey.pcStateManager = stateManager;
            mailboxIdUidKey.pcCopyKeyFieldsFromObjectId(object);
            return mailboxIdUidKey;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
            MailboxIdUidKey mailboxIdUidKey = new MailboxIdUidKey();
            if (bl) {
                mailboxIdUidKey.pcClearFields();
            }
            mailboxIdUidKey.pcStateManager = stateManager;
            return mailboxIdUidKey;
        }

        protected static int pcGetManagedFieldCount() {
            return 2;
        }

        public void pcReplaceField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.mailbox = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                    return;
                }
                case 1: {
                    this.uid = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcReplaceFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcReplaceField(nArray[n]);
                ++n;
            }
        }

        public void pcProvideField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.mailbox);
                    return;
                }
                case 1: {
                    this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.uid);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcProvideFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcProvideField(nArray[n]);
                ++n;
            }
        }

        protected void pcCopyField(MailboxIdUidKey mailboxIdUidKey, int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.mailbox = mailboxIdUidKey.mailbox;
                    return;
                }
                case 1: {
                    this.uid = mailboxIdUidKey.uid;
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcCopyFields(Object object, int[] nArray) {
            MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)object;
            if (mailboxIdUidKey.pcStateManager != this.pcStateManager) {
                throw new IllegalArgumentException();
            }
            if (this.pcStateManager == null) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (n < nArray.length) {
                this.pcCopyField(mailboxIdUidKey, nArray[n]);
                ++n;
            }
        }

        public Object pcGetGenericContext() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getGenericContext();
        }

        public Object pcFetchObjectId() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.fetchObjectId();
        }

        public boolean pcIsDeleted() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isDeleted();
        }

        public boolean pcIsDirty() {
            if (this.pcStateManager == null) {
                return false;
            }
            StateManager stateManager = this.pcStateManager;
            RedefinitionHelper.dirtyCheck((StateManager)stateManager);
            return stateManager.isDirty();
        }

        public boolean pcIsNew() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isNew();
        }

        public boolean pcIsPersistent() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isPersistent();
        }

        public boolean pcIsTransactional() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isTransactional();
        }

        public boolean pcSerializing() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.serializing();
        }

        public void pcDirty(String string) {
            if (this.pcStateManager == null) {
                return;
            }
            this.pcStateManager.dirty(string);
        }

        public StateManager pcGetStateManager() {
            return this.pcStateManager;
        }

        public Object pcGetVersion() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getVersion();
        }

        public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
            if (this.pcStateManager != null) {
                this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
                return;
            }
            this.pcStateManager = stateManager;
        }

        public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        }

        public void pcCopyKeyFieldsToObjectId(Object object) {
        }

        public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        }

        public void pcCopyKeyFieldsFromObjectId(Object object) {
        }

        public Object pcNewObjectIdInstance() {
            return null;
        }

        public Object pcNewObjectIdInstance(Object object) {
            return null;
        }

        public static final long pcGetmailbox(MailboxIdUidKey mailboxIdUidKey) {
            if (mailboxIdUidKey.pcStateManager == null) {
                return mailboxIdUidKey.mailbox;
            }
            int n = pcInheritedFieldCount + 0;
            mailboxIdUidKey.pcStateManager.accessingField(n);
            return mailboxIdUidKey.mailbox;
        }

        public static final void pcSetmailbox(MailboxIdUidKey mailboxIdUidKey, long l) {
            if (mailboxIdUidKey.pcStateManager == null) {
                mailboxIdUidKey.mailbox = l;
                return;
            }
            mailboxIdUidKey.pcStateManager.settingLongField((PersistenceCapable)mailboxIdUidKey, pcInheritedFieldCount + 0, mailboxIdUidKey.mailbox, l, 0);
        }

        public static final long pcGetuid(MailboxIdUidKey mailboxIdUidKey) {
            if (mailboxIdUidKey.pcStateManager == null) {
                return mailboxIdUidKey.uid;
            }
            int n = pcInheritedFieldCount + 1;
            mailboxIdUidKey.pcStateManager.accessingField(n);
            return mailboxIdUidKey.uid;
        }

        public static final void pcSetuid(MailboxIdUidKey mailboxIdUidKey, long l) {
            if (mailboxIdUidKey.pcStateManager == null) {
                mailboxIdUidKey.uid = l;
                return;
            }
            mailboxIdUidKey.pcStateManager.settingLongField((PersistenceCapable)mailboxIdUidKey, pcInheritedFieldCount + 1, mailboxIdUidKey.uid, l, 0);
        }

        public Boolean pcIsDetached() {
            if (this.pcStateManager != null) {
                if (this.pcStateManager.isDetached()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
                return Boolean.TRUE;
            }
            if (!this.pcisDetachedStateDefinitive()) {
                return null;
            }
            if (this.pcGetDetachedState() == null) {
                return Boolean.FALSE;
            }
            return null;
        }

        private boolean pcisDetachedStateDefinitive() {
            return false;
        }

        public Object pcGetDetachedState() {
            return this.pcDetachedState;
        }

        public void pcSetDetachedState(Object object) {
            this.pcDetachedState = object;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            boolean bl = this.pcSerializing();
            objectOutputStream.defaultWriteObject();
            if (bl) {
                this.pcSetDetachedState(null);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
            objectInputStream.defaultReadObject();
        }
    }
}

