/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AuthenticationFailureReason;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityError;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityNotice;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityWarning;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetPasswordPolicyStateIssuesResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.47";
    private static final byte TYPE_NOTICES = -96;
    private static final byte TYPE_WARNINGS = -95;
    private static final byte TYPE_ERRORS = -94;
    private static final byte TYPE_AUTH_FAILURE_REASON = -93;
    private static final long serialVersionUID = 7509027658735069270L;
    @Nullable
    private final AuthenticationFailureReason authFailureReason;
    @NotNull
    private final List<PasswordPolicyStateAccountUsabilityError> errors;
    @NotNull
    private final List<PasswordPolicyStateAccountUsabilityNotice> notices;
    @NotNull
    private final List<PasswordPolicyStateAccountUsabilityWarning> warnings;

    GetPasswordPolicyStateIssuesResponseControl() {
        this.authFailureReason = null;
        this.notices = Collections.emptyList();
        this.warnings = Collections.emptyList();
        this.errors = Collections.emptyList();
    }

    public GetPasswordPolicyStateIssuesResponseControl(@Nullable List<PasswordPolicyStateAccountUsabilityNotice> notices, @Nullable List<PasswordPolicyStateAccountUsabilityWarning> warnings, @Nullable List<PasswordPolicyStateAccountUsabilityError> errors) {
        this(notices, warnings, errors, null);
    }

    public GetPasswordPolicyStateIssuesResponseControl(@Nullable List<PasswordPolicyStateAccountUsabilityNotice> notices, @Nullable List<PasswordPolicyStateAccountUsabilityWarning> warnings, @Nullable List<PasswordPolicyStateAccountUsabilityError> errors, @Nullable AuthenticationFailureReason authFailureReason) {
        super(GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID, false, GetPasswordPolicyStateIssuesResponseControl.encodeValue(notices, warnings, errors, authFailureReason));
        this.authFailureReason = authFailureReason;
        this.notices = notices == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordPolicyStateAccountUsabilityNotice>(notices));
        this.warnings = warnings == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordPolicyStateAccountUsabilityWarning>(warnings));
        this.errors = errors == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordPolicyStateAccountUsabilityError>(errors));
    }

    public GetPasswordPolicyStateIssuesResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_NO_VALUE.get());
        }
        AuthenticationFailureReason afr = null;
        List nList = Collections.emptyList();
        List wList = Collections.emptyList();
        List eList = Collections.emptyList();
        try {
            block9: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -96: {
                        String message;
                        String name;
                        int type;
                        nList = new ArrayList(10);
                        for (ASN1Element ne : ASN1Sequence.decodeAsSequence(e).elements()) {
                            ASN1Element[] noticeElements = ASN1Sequence.decodeAsSequence(ne).elements();
                            type = ASN1Integer.decodeAsInteger(noticeElements[0]).intValue();
                            name = ASN1OctetString.decodeAsOctetString(noticeElements[1]).stringValue();
                            message = noticeElements.length == 3 ? ASN1OctetString.decodeAsOctetString(noticeElements[2]).stringValue() : null;
                            nList.add(new PasswordPolicyStateAccountUsabilityNotice(type, name, message));
                        }
                        nList = Collections.unmodifiableList(nList);
                        continue block9;
                    }
                    case -95: {
                        String message;
                        String name;
                        int type;
                        wList = new ArrayList(10);
                        for (ASN1Element we : ASN1Sequence.decodeAsSequence(e).elements()) {
                            ASN1Element[] warningElements = ASN1Sequence.decodeAsSequence(we).elements();
                            type = ASN1Integer.decodeAsInteger(warningElements[0]).intValue();
                            name = ASN1OctetString.decodeAsOctetString(warningElements[1]).stringValue();
                            message = warningElements.length == 3 ? ASN1OctetString.decodeAsOctetString(warningElements[2]).stringValue() : null;
                            wList.add(new PasswordPolicyStateAccountUsabilityWarning(type, name, message));
                        }
                        wList = Collections.unmodifiableList(wList);
                        continue block9;
                    }
                    case -94: {
                        String message;
                        String name;
                        int type;
                        eList = new ArrayList(10);
                        for (ASN1Element ee : ASN1Sequence.decodeAsSequence(e).elements()) {
                            ASN1Element[] errorElements = ASN1Sequence.decodeAsSequence(ee).elements();
                            type = ASN1Integer.decodeAsInteger(errorElements[0]).intValue();
                            name = ASN1OctetString.decodeAsOctetString(errorElements[1]).stringValue();
                            message = errorElements.length == 3 ? ASN1OctetString.decodeAsOctetString(errorElements[2]).stringValue() : null;
                            eList.add(new PasswordPolicyStateAccountUsabilityError(type, name, message));
                        }
                        eList = Collections.unmodifiableList(eList);
                        continue block9;
                    }
                    case -93: {
                        ASN1Element[] afrElements = ASN1Sequence.decodeAsSequence(e).elements();
                        int afrType = ASN1Integer.decodeAsInteger(afrElements[0]).intValue();
                        String afrName = ASN1OctetString.decodeAsOctetString(afrElements[1]).stringValue();
                        String afrMessage = afrElements.length == 3 ? ASN1OctetString.decodeAsOctetString(afrElements[2]).stringValue() : null;
                        afr = new AuthenticationFailureReason(afrType, afrName, afrMessage);
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_UNEXPECTED_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.authFailureReason = afr;
        this.notices = nList;
        this.warnings = wList;
        this.errors = eList;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable List<PasswordPolicyStateAccountUsabilityNotice> notices, @Nullable List<PasswordPolicyStateAccountUsabilityWarning> warnings, @Nullable List<PasswordPolicyStateAccountUsabilityError> errors, @Nullable AuthenticationFailureReason authFailureReason) {
        ArrayList<ASN1Sequence> elements = new ArrayList<ASN1Sequence>(4);
        if (notices != null && !notices.isEmpty()) {
            ArrayList<ASN1Sequence> noticeElements = new ArrayList<ASN1Sequence>(notices.size());
            for (PasswordPolicyStateAccountUsabilityNotice n : notices) {
                if (n.getMessage() == null) {
                    noticeElements.add(new ASN1Sequence(new ASN1Integer(n.getIntValue()), new ASN1OctetString(n.getName())));
                    continue;
                }
                noticeElements.add(new ASN1Sequence(new ASN1Integer(n.getIntValue()), new ASN1OctetString(n.getName()), new ASN1OctetString(n.getMessage())));
            }
            elements.add(new ASN1Sequence(-96, noticeElements));
        }
        if (warnings != null && !warnings.isEmpty()) {
            ArrayList<ASN1Sequence> warningElements = new ArrayList<ASN1Sequence>(warnings.size());
            for (PasswordPolicyStateAccountUsabilityWarning w : warnings) {
                if (w.getMessage() == null) {
                    warningElements.add(new ASN1Sequence(new ASN1Integer(w.getIntValue()), new ASN1OctetString(w.getName())));
                    continue;
                }
                warningElements.add(new ASN1Sequence(new ASN1Integer(w.getIntValue()), new ASN1OctetString(w.getName()), new ASN1OctetString(w.getMessage())));
            }
            elements.add(new ASN1Sequence(-95, warningElements));
        }
        if (errors != null && !errors.isEmpty()) {
            ArrayList<ASN1Sequence> errorElements = new ArrayList<ASN1Sequence>(errors.size());
            for (PasswordPolicyStateAccountUsabilityError e : errors) {
                if (e.getMessage() == null) {
                    errorElements.add(new ASN1Sequence(new ASN1Integer(e.getIntValue()), new ASN1OctetString(e.getName())));
                    continue;
                }
                errorElements.add(new ASN1Sequence(new ASN1Integer(e.getIntValue()), new ASN1OctetString(e.getName()), new ASN1OctetString(e.getMessage())));
            }
            elements.add(new ASN1Sequence(-94, errorElements));
        }
        if (authFailureReason != null) {
            if (authFailureReason.getMessage() == null) {
                elements.add(new ASN1Sequence(-93, new ASN1Integer(authFailureReason.getIntValue()), new ASN1OctetString(authFailureReason.getName())));
            } else {
                elements.add(new ASN1Sequence(-93, new ASN1Integer(authFailureReason.getIntValue()), new ASN1OctetString(authFailureReason.getName()), new ASN1OctetString(authFailureReason.getMessage())));
            }
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Override
    @NotNull
    public GetPasswordPolicyStateIssuesResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GetPasswordPolicyStateIssuesResponseControl(oid, isCritical, value);
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityNotice> getNotices() {
        return this.notices;
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityWarning> getWarnings() {
        return this.warnings;
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityError> getErrors() {
        return this.errors;
    }

    @Nullable
    public AuthenticationFailureReason getAuthenticationFailureReason() {
        return this.authFailureReason;
    }

    @Nullable
    public static GetPasswordPolicyStateIssuesResponseControl get(@NotNull BindResult bindResult) throws LDAPException {
        Control c = bindResult.getResponseControl(GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetPasswordPolicyStateIssuesResponseControl) {
            return (GetPasswordPolicyStateIssuesResponseControl)c;
        }
        return new GetPasswordPolicyStateIssuesResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Nullable
    public static GetPasswordPolicyStateIssuesResponseControl get(@NotNull LDAPException ldapException) throws LDAPException {
        Control c = ldapException.getResponseControl(GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetPasswordPolicyStateIssuesResponseControl) {
            return (GetPasswordPolicyStateIssuesResponseControl)c;
        }
        return new GetPasswordPolicyStateIssuesResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_PWP_STATE_ISSUES_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetPasswordPolicyStateIssuesResponseControl(notices={ ");
        Iterator<PasswordPolicyStateAccountUsabilityNotice> noticeIterator = this.notices.iterator();
        while (noticeIterator.hasNext()) {
            buffer.append(noticeIterator.next().toString());
            if (!noticeIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, warnings={ ");
        Iterator<PasswordPolicyStateAccountUsabilityWarning> warningIterator = this.warnings.iterator();
        while (warningIterator.hasNext()) {
            buffer.append(warningIterator.next().toString());
            if (!warningIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, errors={ ");
        Iterator<PasswordPolicyStateAccountUsabilityError> errorIterator = this.errors.iterator();
        while (errorIterator.hasNext()) {
            buffer.append(errorIterator.next().toString());
            if (!errorIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        if (this.authFailureReason != null) {
            buffer.append(", authFailureReason=");
            buffer.append(this.authFailureReason.toString());
        }
        buffer.append(')');
    }
}

