/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import org.apache.commons.logging.Log;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.Executable;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.tests.ExecutableTest;

public class Test
implements Executable {
    private String fieldName;
    private Arguments fieldArguments;

    @Override
    public Object execute(MailAdapter mail, SieveContext context) throws SieveException {
        return this.isTestPassed(mail, context);
    }

    public boolean isTestPassed(MailAdapter mail, SieveContext context) throws SieveException {
        Log log = context.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.toString());
        }
        String name = this.getName();
        ExecutableTest test = context.getTestManager().getTest(name);
        return test.execute(mail, this.getArguments(), context);
    }

    private Test() {
    }

    public Test(String name, Arguments arguments) {
        this();
        this.setName(name);
        this.setArguments(arguments);
    }

    public Arguments getArguments() {
        return this.fieldArguments;
    }

    public String getName() {
        return this.fieldName;
    }

    protected void setArguments(Arguments arguments) {
        this.fieldArguments = arguments;
    }

    protected void setName(String name) {
        this.fieldName = name;
    }

    public String toString() {
        return "Test name: " + this.getName() + " " + (this.getArguments() == null ? "null" : this.getArguments().toString());
    }
}

