/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport;

import com.google.common.base.Preconditions;
import java.security.KeyStore;
import java.util.Optional;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.transport.KeyFileType;
import org.apache.james.transport.KeyStoreHolderFactory;
import org.apache.mailet.MailetConfig;

public abstract class KeyStoreHolderConfiguration {
    public static final String FILE_TYPE = "fileType";
    public static final String KEY_STORE_TYPE = "keyStoreType";
    public static final String KEY_STORE_FILE_NAME = "keyStoreFileName";
    public static final String KEY_STORE_PASSWORD = "keyStorePassword";
    public static final String PEM_FILE_NAME = "pemFileName";
    public static final String KEY_STORE_TYPE_DEFAULT_VALUE = KeyStore.getDefaultType();
    public static final String KEY_STORE_PASSWORD_DEFAULT_VALUE = "";

    public static Builder builder() {
        return new Builder();
    }

    public static KeyStoreHolderConfiguration from(MailetConfig config) {
        return KeyStoreHolderConfiguration.builder().setFileType(KeyFileType.parse(Optional.ofNullable(config.getInitParameter(FILE_TYPE)))).setKeyStoreType(Optional.ofNullable(config.getInitParameter(KEY_STORE_TYPE))).setKeyStoreFileName(Optional.ofNullable(config.getInitParameter(KEY_STORE_FILE_NAME))).setKeyStorePassword(Optional.ofNullable(config.getInitParameter(KEY_STORE_PASSWORD))).setPemFileName(Optional.ofNullable(config.getInitParameter(PEM_FILE_NAME))).build();
    }

    public abstract KeyStoreHolderFactory.FileLoader getFileLoader(FileSystem var1);

    public static class Builder {
        private KeyFileType fileType;
        private Optional<String> keyStoreType;
        private Optional<String> keyStoreFileName;
        private Optional<String> keyStorePassword;
        private Optional<String> pemFileName;

        public Builder setFileType(KeyFileType fileType) {
            this.fileType = fileType;
            return this;
        }

        public Builder setKeyStoreType(Optional<String> keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder setKeyStoreFileName(Optional<String> keyStoreFileName) {
            this.keyStoreFileName = keyStoreFileName;
            return this;
        }

        public Builder setKeyStorePassword(Optional<String> keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder setPemFileName(Optional<String> pemFileName) {
            this.pemFileName = pemFileName;
            return this;
        }

        public KeyStoreHolderConfiguration build() {
            switch (this.fileType) {
                case KEYSTORE: {
                    return new KeyStoreConfiguration(this.keyStoreType.orElse(KEY_STORE_TYPE_DEFAULT_VALUE), this.keyStoreFileName, this.keyStorePassword.orElse(KeyStoreHolderConfiguration.KEY_STORE_PASSWORD_DEFAULT_VALUE));
                }
                case PEM: {
                    Preconditions.checkArgument((this.pemFileName.isPresent() && !this.pemFileName.get().isBlank() ? 1 : 0) != 0, (Object)"pemFileName must not be empty");
                    return new PemConfiguration(this.pemFileName.get());
                }
            }
            throw new RuntimeException("Unsupported file type " + String.valueOf((Object)this.fileType));
        }
    }

    public static class PemConfiguration
    extends KeyStoreHolderConfiguration {
        private final String pemFileName;

        private PemConfiguration(String pemFileName) {
            this.pemFileName = pemFileName;
        }

        public String getPemFileName() {
            return this.pemFileName;
        }

        @Override
        public KeyStoreHolderFactory.FileLoader getFileLoader(FileSystem fileSystem) {
            return new KeyStoreHolderFactory.PemFileLoader(fileSystem);
        }
    }

    public static class KeyStoreConfiguration
    extends KeyStoreHolderConfiguration {
        private final String keyStoreType;
        private final Optional<String> keyStoreFileName;
        private final String keyStorePassword;

        private KeyStoreConfiguration(String keyStoreType, Optional<String> keyStoreFileName, String keyStorePassword) {
            this.keyStoreType = keyStoreType;
            this.keyStoreFileName = keyStoreFileName;
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public Optional<String> getKeyStoreFileName() {
            return this.keyStoreFileName;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        @Override
        public KeyStoreHolderFactory.FileLoader getFileLoader(FileSystem fileSystem) {
            return new KeyStoreHolderFactory.KeyStoreFileLoader(fileSystem);
        }
    }
}

