/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.ternary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;

public abstract class TernaryViewExpression
extends ViewExpression {
    protected final ViewExpression firstExpression;
    protected final ViewExpression secondExpression;
    protected final ViewExpression thirdExpression;

    protected TernaryViewExpression(ViewExpression firstExpression, ViewExpression secondExpression, ViewExpression thirdExpression) {
        this.firstExpression = firstExpression;
        this.secondExpression = secondExpression;
        this.thirdExpression = thirdExpression;
    }

    protected TernaryViewExpression(ByteBuffer byteBuffer) {
        this.firstExpression = ViewExpression.deserialize(byteBuffer);
        this.secondExpression = ViewExpression.deserialize(byteBuffer);
        this.thirdExpression = ViewExpression.deserialize(byteBuffer);
    }

    protected TernaryViewExpression(InputStream inputStream) {
        this.firstExpression = ViewExpression.deserialize(inputStream);
        this.secondExpression = ViewExpression.deserialize(inputStream);
        this.thirdExpression = ViewExpression.deserialize(inputStream);
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTernaryExpression(this, context);
    }

    @Override
    protected final boolean isLeafOperandInternal() {
        return false;
    }

    @Override
    public final List<ViewExpression> getChildViewExpressions() {
        return Arrays.asList(this.firstExpression, this.secondExpression, this.thirdExpression);
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ViewExpression.serialize(this.firstExpression, byteBuffer);
        ViewExpression.serialize(this.secondExpression, byteBuffer);
        ViewExpression.serialize(this.thirdExpression, byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        ViewExpression.serialize(this.firstExpression, stream);
        ViewExpression.serialize(this.secondExpression, stream);
        ViewExpression.serialize(this.thirdExpression, stream);
    }

    public ViewExpression getFirstExpression() {
        return this.firstExpression;
    }

    public ViewExpression getSecondExpression() {
        return this.secondExpression;
    }

    public ViewExpression getThirdExpression() {
        return this.thirdExpression;
    }
}

