/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSavingStateFactory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.SpaceSavingBigArray;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.utils.Binary;

public abstract class AbstractGroupedApproxMostFrequentAccumulator<T>
implements GroupedAccumulator {
    protected final SpaceSavingStateFactory.GroupedSpaceSavingState<T> state = SpaceSavingStateFactory.createGroupedState();

    @Override
    public void setGroupCount(long groupCount) {
        this.state.getSpaceSavings().ensureCapacity(groupCount);
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        columnBuilder.writeBinary(new Binary(this.state.getSpaceSavings().get(groupId).serialize()));
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        Binary result = new Binary(new Gson().toJson(this.state.getSpaceSavings().get(groupId).getBuckets()), StandardCharsets.UTF_8);
        columnBuilder.writeBinary(result);
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.state.getSpaceSavings().reset();
    }

    public SpaceSavingBigArray<T> getOrCreateSpaceSaving(SpaceSavingStateFactory.GroupedSpaceSavingState<T> state) {
        if (state.isEmpty()) {
            state.setSpaceSavings(new SpaceSavingBigArray());
        }
        return state.getSpaceSavings();
    }
}

