/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadAtTimeDetails
extends HistoryReadDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=653");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=655");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=654");
    private final DateTime[] reqTimes;
    private final Boolean useSimpleBounds;

    public ReadAtTimeDetails(DateTime[] reqTimes, Boolean useSimpleBounds) {
        this.reqTimes = reqTimes;
        this.useSimpleBounds = useSimpleBounds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime[] getReqTimes() {
        return this.reqTimes;
    }

    public Boolean getUseSimpleBounds() {
        return this.useSimpleBounds;
    }

    protected ReadAtTimeDetails(ReadAtTimeDetailsBuilder<?, ?> b) {
        super((HistoryReadDetails.HistoryReadDetailsBuilder<?, ?>)b);
        this.reqTimes = ((ReadAtTimeDetailsBuilder)b).reqTimes;
        this.useSimpleBounds = ((ReadAtTimeDetailsBuilder)b).useSimpleBounds;
    }

    public static ReadAtTimeDetailsBuilder<?, ?> builder() {
        return new ReadAtTimeDetailsBuilderImpl();
    }

    public ReadAtTimeDetailsBuilder<?, ?> toBuilder() {
        return new ReadAtTimeDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadAtTimeDetails)) {
            return false;
        }
        ReadAtTimeDetails other = (ReadAtTimeDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$useSimpleBounds = this.getUseSimpleBounds();
        Boolean other$useSimpleBounds = other.getUseSimpleBounds();
        if (this$useSimpleBounds == null ? other$useSimpleBounds != null : !((Object)this$useSimpleBounds).equals(other$useSimpleBounds)) {
            return false;
        }
        return Arrays.deepEquals(this.getReqTimes(), other.getReqTimes());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadAtTimeDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $useSimpleBounds = this.getUseSimpleBounds();
        result = result * 59 + ($useSimpleBounds == null ? 43 : ((Object)$useSimpleBounds).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReqTimes());
        return result;
    }

    @Override
    public String toString() {
        return "ReadAtTimeDetails(reqTimes=" + Arrays.deepToString(this.getReqTimes()) + ", useSimpleBounds=" + this.getUseSimpleBounds() + ")";
    }

    private static final class ReadAtTimeDetailsBuilderImpl
    extends ReadAtTimeDetailsBuilder<ReadAtTimeDetails, ReadAtTimeDetailsBuilderImpl> {
        private ReadAtTimeDetailsBuilderImpl() {
        }

        @Override
        protected ReadAtTimeDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ReadAtTimeDetails build() {
            return new ReadAtTimeDetails(this);
        }
    }

    public static abstract class ReadAtTimeDetailsBuilder<C extends ReadAtTimeDetails, B extends ReadAtTimeDetailsBuilder<C, B>>
    extends HistoryReadDetails.HistoryReadDetailsBuilder<C, B> {
        private DateTime[] reqTimes;
        private Boolean useSimpleBounds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadAtTimeDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReadAtTimeDetails instance, ReadAtTimeDetailsBuilder<?, ?> b) {
            b.reqTimes(instance.reqTimes);
            b.useSimpleBounds(instance.useSimpleBounds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B reqTimes(DateTime[] reqTimes) {
            this.reqTimes = reqTimes;
            return (B)this.self();
        }

        public B useSimpleBounds(Boolean useSimpleBounds) {
            this.useSimpleBounds = useSimpleBounds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReadAtTimeDetails.ReadAtTimeDetailsBuilder(super=" + super.toString() + ", reqTimes=" + Arrays.deepToString(this.reqTimes) + ", useSimpleBounds=" + this.useSimpleBounds + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReadAtTimeDetails> {
        @Override
        public Class<ReadAtTimeDetails> getType() {
            return ReadAtTimeDetails.class;
        }

        @Override
        public ReadAtTimeDetails decode(SerializationContext context, UaDecoder decoder) {
            DateTime[] reqTimes = decoder.readDateTimeArray("ReqTimes");
            Boolean useSimpleBounds = decoder.readBoolean("UseSimpleBounds");
            return new ReadAtTimeDetails(reqTimes, useSimpleBounds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReadAtTimeDetails value) {
            encoder.writeDateTimeArray("ReqTimes", value.getReqTimes());
            encoder.writeBoolean("UseSimpleBounds", value.getUseSimpleBounds());
        }
    }
}

