/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.Utils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class FirstByAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FirstByAccumulator.class);
    private final TSDataType xDataType;
    private final TSDataType yDataType;
    private final boolean xIsTimeColumn;
    private final boolean yIsTimeColumn;
    private long yFirstTime = Long.MAX_VALUE;
    private final TsPrimitiveType xResult;
    private boolean xIsNull = true;
    private boolean initResult = false;

    public FirstByAccumulator(TSDataType xDataType, TSDataType yDataType, boolean xIsTimeColumn, boolean yIsTimeColumn) {
        this.xDataType = xDataType;
        this.yDataType = yDataType;
        this.xIsTimeColumn = xIsTimeColumn;
        this.yIsTimeColumn = yIsTimeColumn;
        this.xResult = TsPrimitiveType.getByType((TSDataType)xDataType);
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new FirstByAccumulator(this.xDataType, this.yDataType, this.xIsTimeColumn, this.yIsTimeColumn);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        Preconditions.checkArgument((arguments.length == 3 ? 1 : 0) != 0, (Object)"Length of input Column[] for FIRST_BY should be 3");
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(arguments[0], arguments[1], arguments[2], mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in FIRST_BY Aggregation: %s", this.yDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of FIRST_BY should be BinaryColumn");
        block8: for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            long curTime = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)0);
            int offset = 8;
            boolean isXNull = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
            ++offset;
            if (isXNull) {
                if (this.initResult && curTime >= this.yFirstTime) continue;
                this.initResult = true;
                this.yFirstTime = curTime;
                this.xIsNull = true;
                continue;
            }
            switch (this.xDataType) {
                case INT32: 
                case DATE: {
                    int xIntVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    this.updateIntFirstValue(xIntVal, curTime);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long longVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                    this.updateLongFirstValue(longVal, curTime);
                    continue block8;
                }
                case FLOAT: {
                    float floatVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                    this.updateFloatFirstValue(floatVal, curTime);
                    continue block8;
                }
                case DOUBLE: {
                    double doubleVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                    this.updateDoubleFirstValue(doubleVal, curTime);
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    Binary binaryVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                    this.updateBinaryFirstValue(binaryVal, curTime);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean boolVal = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                    this.updateBooleanFirstValue(boolVal, curTime);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in FIRST_BY Aggregation: %s", this.yDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of FIRST_BY should be BinaryColumn");
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(this.xDataType, this.yFirstTime, this.xIsNull, this.xResult)));
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult || this.xIsNull) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.xResult.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.xResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.xResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.xResult.getDouble());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                columnBuilder.writeBinary(this.xResult.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.xResult.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in FIRST_BY Aggregation: %s", this.xDataType));
            }
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.initResult;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        block13: {
            Statistics yStatistics;
            block11: {
                Statistics xStatistics;
                block12: {
                    xStatistics = statistics[0];
                    yStatistics = statistics[1];
                    if (this.yIsTimeColumn && yStatistics == null || this.xIsTimeColumn && xStatistics == null) {
                        return;
                    }
                    if (!this.yIsTimeColumn) break block11;
                    if (xStatistics != null && xStatistics.getStartTime() <= yStatistics.getStartTime()) break block12;
                    if (!this.initResult || yStatistics.getStartTime() < this.yFirstTime) {
                        this.initResult = true;
                        this.yFirstTime = yStatistics.getStartTime();
                        this.xIsNull = true;
                    }
                    break block13;
                }
                if (this.initResult && yStatistics.getStartTime() >= this.yFirstTime) break block13;
                this.initResult = true;
                this.yFirstTime = yStatistics.getStartTime();
                this.xIsNull = false;
                switch (this.xDataType) {
                    case INT32: 
                    case DATE: {
                        this.xResult.setInt(((Integer)xStatistics.getFirstValue()).intValue());
                        break block13;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        this.xResult.setLong(((Long)xStatistics.getFirstValue()).longValue());
                        break block13;
                    }
                    case FLOAT: {
                        this.xResult.setFloat(((Float)statistics[0].getFirstValue()).floatValue());
                        break block13;
                    }
                    case DOUBLE: {
                        this.xResult.setDouble(((Double)statistics[0].getFirstValue()).doubleValue());
                        break block13;
                    }
                    case TEXT: 
                    case STRING: 
                    case BLOB: {
                        this.xResult.setBinary((Binary)statistics[0].getFirstValue());
                        break block13;
                    }
                    case BOOLEAN: {
                        this.xResult.setBoolean(((Boolean)statistics[0].getFirstValue()).booleanValue());
                        break block13;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Unsupported data type in FIRST_BY Aggregation: %s", this.yDataType));
                    }
                }
            }
            if (!(yStatistics == null || this.initResult && yStatistics.getStartTime() >= this.yFirstTime)) {
                this.initResult = true;
                this.xIsNull = false;
                this.yFirstTime = yStatistics.getStartTime();
                this.xResult.setLong(yStatistics.getStartTime());
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.xIsNull = true;
        this.yFirstTime = Long.MAX_VALUE;
        this.xResult.reset();
    }

    protected void addIntInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateIntFirstValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateIntFirstValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateIntFirstValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setInt(xColumn.getInt(xIdx));
            }
        }
    }

    protected void updateIntFirstValue(int val, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            this.xIsNull = false;
            this.xResult.setInt(val);
        }
    }

    protected void addLongInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateLongFirstValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateLongFirstValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateLongFirstValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setLong(xColumn.getLong(xIdx));
            }
        }
    }

    protected void updateLongFirstValue(long value, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            this.xIsNull = false;
            this.xResult.setLong(value);
        }
    }

    protected void addFloatInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateFloatFirstValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateFloatFirstValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateFloatFirstValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setFloat(xColumn.getFloat(xIdx));
            }
        }
    }

    protected void updateFloatFirstValue(float value, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            this.xIsNull = false;
            this.xResult.setFloat(value);
        }
    }

    protected void addDoubleInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateDoubleFirstValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateDoubleFirstValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateDoubleFirstValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setDouble(xColumn.getDouble(xIdx));
            }
        }
    }

    protected void updateDoubleFirstValue(double val, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            this.xIsNull = false;
            this.xResult.setDouble(val);
        }
    }

    protected void addBinaryInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateBinaryFirstValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateBinaryFirstValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateBinaryFirstValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setBinary(xColumn.getBinary(xIdx));
            }
        }
    }

    protected void updateBinaryFirstValue(Binary val, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            this.xIsNull = false;
            this.xResult.setBinary(val);
        }
    }

    protected void addBooleanInput(Column xColumn, Column yColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (yColumn.isNull(i)) continue;
                this.updateBooleanFirstValue(xColumn, i, timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (yColumn.isNull(position)) continue;
                this.updateBooleanFirstValue(xColumn, position, timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateBooleanFirstValue(Column xColumn, int xIdx, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            if (xColumn.isNull(xIdx)) {
                this.xIsNull = true;
            } else {
                this.xIsNull = false;
                this.xResult.setBoolean(xColumn.getBoolean(xIdx));
            }
        }
    }

    protected void updateBooleanFirstValue(boolean val, long curTime) {
        if (!this.initResult || curTime < this.yFirstTime) {
            this.initResult = true;
            this.yFirstTime = curTime;
            this.xIsNull = false;
            this.xResult.setBoolean(val);
        }
    }
}

