/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2.handler;

import java.util.ArrayList;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.v2.model.PrefixPathList;
import org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;

public class FastLastHandler {
    public static TSLastDataQueryReq createTSLastDataQueryReq(IClientSession clientSession, PrefixPathList prefixPathList) {
        TSLastDataQueryReq req = new TSLastDataQueryReq();
        req.sessionId = clientSession.getId();
        req.paths = Collections.singletonList(String.join((CharSequence)".", prefixPathList.getPrefixPaths()) + ".**");
        req.time = Long.MIN_VALUE;
        req.setLegalPathNodes(true);
        return req;
    }

    public static Response buildErrorResponse(TSStatusCode statusCode) {
        return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(statusCode.getStatusCode())).message(statusCode.name())).build();
    }

    public static Response buildExecutionStatusResponse(TSStatus status) {
        return Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.v2.model.ExecutionStatus().code(Integer.valueOf(status.getCode())).message(status.getMessage())).build();
    }

    public static void setupTargetDataSet(QueryDataSet dataSet) {
        dataSet.addExpressionsItem("Timeseries");
        dataSet.addExpressionsItem("Value");
        dataSet.addExpressionsItem("DataType");
        dataSet.addDataTypesItem("TEXT");
        dataSet.addDataTypesItem("TEXT");
        dataSet.addDataTypesItem("TEXT");
        dataSet.setValues(new ArrayList());
        dataSet.setTimestamps(new ArrayList());
    }
}

