/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.quota;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.common.rpc.thrift.TTimedQuota;
import org.apache.iotdb.common.rpc.thrift.ThrottleType;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetThrottleQuotaPlan
extends ConfigPhysicalPlan {
    private String userName;
    private TThrottleQuota throttleQuota;

    public SetThrottleQuotaPlan() {
        super(ConfigPhysicalPlanType.setThrottleQuota);
    }

    public SetThrottleQuotaPlan(String userName, TThrottleQuota throttleQuota) {
        super(ConfigPhysicalPlanType.setThrottleQuota);
        this.userName = userName;
        this.throttleQuota = throttleQuota;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public TThrottleQuota getThrottleQuota() {
        return this.throttleQuota;
    }

    public void setThrottleQuota(TThrottleQuota throttleQuota) {
        this.throttleQuota = throttleQuota;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        BasicStructureSerDeUtil.write((String)this.userName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((int)this.throttleQuota.getThrottleLimit().size(), (DataOutputStream)stream);
        for (Map.Entry entry : this.throttleQuota.getThrottleLimit().entrySet()) {
            BasicStructureSerDeUtil.write((String)((ThrottleType)entry.getKey()).name(), (DataOutputStream)stream);
            BasicStructureSerDeUtil.write((long)((TTimedQuota)entry.getValue()).getTimeUnit(), (DataOutputStream)stream);
            BasicStructureSerDeUtil.write((long)((TTimedQuota)entry.getValue()).getSoftLimit(), (DataOutputStream)stream);
        }
        BasicStructureSerDeUtil.write((long)this.throttleQuota.getMemLimit(), (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((int)this.throttleQuota.getCpuLimit(), (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.userName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        EnumMap<ThrottleType, TTimedQuota> throttleLimit = new EnumMap<ThrottleType, TTimedQuota>(ThrottleType.class);
        int size = BasicStructureSerDeUtil.readInt((ByteBuffer)buffer);
        for (int i = 0; i < size; ++i) {
            ThrottleType throttleType = ThrottleType.valueOf((String)BasicStructureSerDeUtil.readString((ByteBuffer)buffer));
            long timeUnit = BasicStructureSerDeUtil.readLong((ByteBuffer)buffer);
            long softLimit = BasicStructureSerDeUtil.readLong((ByteBuffer)buffer);
            throttleLimit.put(throttleType, new TTimedQuota(timeUnit, softLimit));
        }
        TThrottleQuota tmpThrottleQuota = new TThrottleQuota();
        tmpThrottleQuota.setThrottleLimit(throttleLimit);
        tmpThrottleQuota.setMemLimit(BasicStructureSerDeUtil.readLong((ByteBuffer)buffer));
        tmpThrottleQuota.setCpuLimit(BasicStructureSerDeUtil.readInt((ByteBuffer)buffer));
        this.throttleQuota = tmpThrottleQuota;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SetThrottleQuotaPlan that = (SetThrottleQuotaPlan)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.throttleQuota, that.throttleQuota);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userName, this.throttleQuota);
    }
}

