/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.Closeable;
import java.util.Objects;

public class SetThreadName
implements Closeable {
    private final String originalThreadName;

    public SetThreadName(String suffix) {
        Objects.requireNonNull(suffix, "Suffix is null");
        this.originalThreadName = Thread.currentThread().getName();
        int index = this.originalThreadName.indexOf("$");
        if (index < 0) {
            Thread.currentThread().setName(this.originalThreadName + '$' + suffix);
        } else {
            Thread.currentThread().setName(this.originalThreadName.substring(0, index) + '$' + suffix);
        }
    }

    @Override
    public void close() {
        Thread.currentThread().setName(this.originalThreadName);
    }
}

