/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.FileLoaderUtils;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.AlignedDescPriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.AlignedPriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.DescPriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.PriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AlignedSeriesScanUtil
extends SeriesScanUtil {
    private final List<TSDataType> dataTypes;
    private final boolean queryAllSensors;

    public AlignedSeriesScanUtil(PartialPath seriesPath, Ordering scanOrder, SeriesScanOptions scanOptions, FragmentInstanceContext context) {
        this(seriesPath, scanOrder, scanOptions, context, false, null);
    }

    public AlignedSeriesScanUtil(PartialPath seriesPath, Ordering scanOrder, SeriesScanOptions scanOptions, FragmentInstanceContext context, boolean queryAllSensors, List<TSDataType> givenDataTypes) {
        super(seriesPath, scanOrder, scanOptions, context);
        this.isAligned = true;
        this.dataTypes = givenDataTypes != null ? givenDataTypes : ((AlignedPath)seriesPath).getSchemaList().stream().map(IMeasurementSchema::getType).collect(Collectors.toList());
        this.queryAllSensors = queryAllSensors;
    }

    @Override
    protected PriorityMergeReader getPriorityMergeReader() {
        return new AlignedPriorityMergeReader();
    }

    @Override
    protected DescPriorityMergeReader getDescPriorityMergeReader() {
        return new AlignedDescPriorityMergeReader();
    }

    protected AlignedTimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, boolean isSeq) throws IOException {
        return FileLoaderUtils.loadAlignedTimeSeriesMetadata(resource, (AlignedPath)this.seriesPath, this.context, this.scanOptions.getGlobalTimeFilter(), isSeq);
    }

    @Override
    public List<TSDataType> getTsDataTypeList() {
        return this.dataTypes;
    }

    @Override
    protected IPointReader getPointReader(TsBlock tsBlock) {
        return tsBlock.getTsBlockAlignedRowIterator();
    }

    @Override
    protected boolean timeAllSelected(IMetadata metadata) {
        if (this.queryAllSensors || metadata.getMeasurementCount() == 0) {
            return true;
        }
        return metadata.timeAllSelected();
    }
}

