/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.WriteContext;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.KeyValueTupleStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteTriConsumer;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientKeyValueBinaryView
extends AbstractClientView<Map.Entry<Tuple, Tuple>>
implements KeyValueView<Tuple, Tuple> {
    private final ClientTupleSerializer ser;

    ClientKeyValueBinaryView(ClientTable tbl, ClientSql sql) {
        super(tbl, sql);
        this.ser = new ClientTupleSerializer(tbl.tableId());
    }

    public Tuple get(@Nullable Transaction tx, Tuple key) {
        return (Tuple)ViewUtils.sync(this.getAsync(tx, key));
    }

    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public Map<Tuple, Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Map)ViewUtils.sync(this.getAllAsync(tx, keys));
    }

    public CompletableFuture<Map<Tuple, Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.emptyMapCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(15, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readKvTuplesNullable(s, r.in()), Collections.emptyMap(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keys, ClientTupleSerializer.getPartitionAwarenessProvider(keys.iterator().next()));
        }
        return this.tbl.split(tx, keys, clo, new HashMap(), (agg, cur) -> {
            agg.putAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public NullableValue<Tuple> getNullable(@Nullable Transaction tx, Tuple key) {
        return (NullableValue)ViewUtils.sync(this.getNullableAsync(tx, key));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> NullableValue.of((Object)ClientTupleSerializer.readValueTuple(s, r.in())), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public Tuple getOrDefault(@Nullable Transaction tx, Tuple key, Tuple defaultValue) {
        return (Tuple)ViewUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    public CompletableFuture<Tuple> getOrDefaultAsync(@Nullable Transaction tx, Tuple key, Tuple defaultValue) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), defaultValue, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean contains(@Nullable Transaction tx, Tuple key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutOpAsync(33, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutOpAsync(67, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keys, ClientTupleSerializer.getPartitionAwarenessProvider(keys.iterator().next()));
        }
        return this.tbl.split(tx, keys, clo, Boolean.TRUE, (agg, cur) -> agg != false && cur != false, ClientTupleSerializer::getColocationHash);
    }

    public void put(@Nullable Transaction tx, Tuple key, @Nullable Tuple val) {
        ViewUtils.sync(this.putAsync(tx, key, val));
    }

    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutOpAsync(10, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public void putAll(@Nullable Transaction tx, Map<Tuple, Tuple> pairs) {
        ViewUtils.sync(this.putAllAsync(tx, pairs));
    }

    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<Tuple, Tuple> pairs) {
        Objects.requireNonNull(pairs, "pairs");
        for (Map.Entry<Tuple, Tuple> entry2 : pairs.entrySet()) {
            Objects.requireNonNull(entry2.getKey(), "key");
            Objects.requireNonNull(entry2.getValue(), "val");
        }
        if (pairs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutOpAsync(13, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuples(tx, (Collection<Map.Entry<Tuple, Tuple>>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n)), r -> null, (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(pairs.entrySet(), ClientTupleSerializer.getPartitionAwarenessProvider(pairs.keySet().iterator().next()));
        }
        return this.tbl.split(tx, pairs.entrySet(), clo, null, (agg, cur) -> null, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, (Tuple)entry.getKey()));
    }

    public Tuple getAndPut(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Tuple)ViewUtils.sync(this.getAndPutAsync(tx, key, val));
    }

    public CompletableFuture<Tuple> getAndPutAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutInOpAsync(16, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public NullableValue<Tuple> getNullableAndPut(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndPutAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutInOpAsync(16, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> NullableValue.of((Object)ClientTupleSerializer.readValueTuple(s, r.in())), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean putIfAbsent(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, Tuple key, @Nullable Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutOpAsync(18, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean remove(@Nullable Transaction tx, Tuple key) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutOpAsync(28, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutOpAsync(30, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public Collection<Tuple> removeAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Collection)ViewUtils.sync(this.removeAllAsync(tx, keys));
    }

    public void removeAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.removeAllAsync(tx));
    }

    public CompletableFuture<Collection<Tuple>> removeAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.emptyCollectionCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(29, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuples(s, r.in(), true), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keys, ClientTupleSerializer.getPartitionAwarenessProvider(keys.iterator().next()));
        }
        return this.tbl.split(tx, keys, clo, new HashSet(), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name(), new Object[0]).thenApply(r -> null);
    }

    public Tuple getAndRemove(@Nullable Transaction tx, Tuple key) {
        return (Tuple)ViewUtils.sync(this.getAndRemoveAsync(tx, key));
    }

    public CompletableFuture<Tuple> getAndRemoveAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(32, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public NullableValue<Tuple> getNullableAndRemove(@Nullable Transaction tx, Tuple key) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndRemoveAsync(tx, key));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndRemoveAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(32, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> NullableValue.of((Object)ClientTupleSerializer.readValueTuple(s, r.in())), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean replace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, Tuple key, Tuple oldVal, Tuple newVal) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutOpAsync(22, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple key, Tuple oldVal, Tuple newVal) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(oldVal, "oldVal");
        Objects.requireNonNull(newVal, "newVal");
        return this.tbl.doSchemaOutOpAsync(24, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            this.ser.writeKvTuple(tx, key, oldVal, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false);
            this.ser.writeKvTuple(tx, key, newVal, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true);
        }), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public Tuple getAndReplace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Tuple)ViewUtils.sync(this.getAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutInOpAsync(26, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public NullableValue<Tuple> getNullableAndReplace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndReplaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutInOpAsync(26, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> NullableValue.of((Object)ClientTupleSerializer.readValueTuple(s, r.in())), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<Tuple, Tuple>>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher, "publisher");
        KeyValueTupleStreamerPartitionAwarenessProvider provider = new KeyValueTupleStreamerPartitionAwarenessProvider(this.tbl);
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partition, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeStreamerKvTuples((int)partition, items, deleted, (ClientSchema)s, (PayloadOutputChannel)w)), r -> null, PartitionAwarenessProvider.of(partition), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, Map.Entry<Tuple, Tuple>> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new KeyValueTupleStreamerPartitionAwarenessProvider(this.tbl), this.tbl, resultSubscriber, receiver, receiverArg);
    }

    @Override
    protected Function<SqlRow, Map.Entry<Tuple, Tuple>> queryMapper(ResultSetMetadata meta, ClientSchema schema) {
        String[] keyCols = ClientKeyValueBinaryView.columnNames(schema.keyColumns());
        String[] valCols = ClientKeyValueBinaryView.columnNames(schema.valColumns());
        return row -> new IgniteBiTuple((Object)new SqlRowProjection(row, meta, keyCols), (Object)new SqlRowProjection(row, meta, valCols));
    }
}

