/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.event;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.internal.cli.event.Event;
import org.apache.ignite.internal.cli.event.EventListener;
import org.apache.ignite.internal.cli.event.EventPublisher;
import org.apache.ignite.internal.cli.event.EventSubscriptionManager;
import org.apache.ignite.internal.cli.event.EventType;
import org.apache.ignite.internal.cli.logger.CliLoggers;
import org.apache.ignite.internal.logger.IgniteLogger;

@Singleton
public class EventFactory
implements EventPublisher,
EventSubscriptionManager {
    private static final IgniteLogger LOG = CliLoggers.forClass(EventFactory.class);
    private final ConcurrentHashMap<EventType, List<EventListener>> listeners = new ConcurrentHashMap();

    @Override
    public void subscribe(EventType eventType, EventListener eventListener) {
        this.listeners.computeIfAbsent(eventType, evtKey -> new CopyOnWriteArrayList()).add(eventListener);
    }

    @Override
    public void removeSubscription(EventType eventType, EventListener eventListener) {
        this.listeners.computeIfPresent(eventType, (eventType1, eventListeners) -> {
            eventListeners.remove(eventListener);
            return eventListeners;
        });
    }

    @Override
    public void publish(Event event) {
        List<EventListener> eventListeners = this.listeners.get((Object)event.eventType());
        if (eventListeners == null) {
            return;
        }
        eventListeners.forEach(listener -> {
            try {
                listener.onEvent(event);
            }
            catch (Exception exception) {
                LOG.warn("Got an exception: ", (Throwable)exception);
            }
        });
    }
}

